/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.CatalogExtensionPointReader;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogRegistry {
    private static CatalogRegistry instance;
    private final List<CatalogDescriptor> catalogDescriptors = new CopyOnWriteArrayList<CatalogDescriptor>();
    private final Map<String, INews> catalogNews = new HashMap<String, INews>();

    public static synchronized CatalogRegistry getInstance() {
        if (instance == null) {
            instance = new CatalogRegistry();
        }
        return instance;
    }

    public CatalogRegistry() {
        this.catalogDescriptors.addAll(new CatalogExtensionPointReader().getCatalogDescriptors());
    }

    public void register(CatalogDescriptor catalogDescriptor) {
        this.catalogDescriptors.add(new CatalogDescriptor(catalogDescriptor));
    }

    public void unregister(CatalogDescriptor catalogDescriptor) {
        this.catalogDescriptors.remove(catalogDescriptor);
        this.removeCatalogNews(catalogDescriptor);
    }

    public List<CatalogDescriptor> getCatalogDescriptors() {
        return Collections.unmodifiableList(this.catalogDescriptors);
    }

    @Deprecated
    public void addCatalogBranding(CatalogDescriptor descriptor, ICatalogBranding branding) {
        if (descriptor != null) {
            descriptor.setCatalogBranding(branding);
        }
    }

    @Deprecated
    public ICatalogBranding getCatalogBranding(CatalogDescriptor descriptor) {
        return descriptor == null ? null : descriptor.getCatalogBranding();
    }

    public void addCatalogNews(CatalogDescriptor descriptor, INews news) {
        this.catalogNews.put(descriptor.getUrl().toExternalForm(), news);
    }

    private void removeCatalogNews(CatalogDescriptor descriptor) {
        this.catalogNews.remove(descriptor.getUrl().toExternalForm());
    }

    public INews getCatalogNews(CatalogDescriptor descriptor) {
        return this.catalogNews.get(descriptor.getUrl().toExternalForm());
    }

    public CatalogDescriptor findCatalogDescriptor(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        for (CatalogDescriptor catalogDescriptor : this.catalogDescriptors) {
            if (!url.startsWith(catalogDescriptor.getUrl().toExternalForm())) continue;
            return catalogDescriptor;
        }
        url = URLUtil.toggleHttps((String)url);
        for (CatalogDescriptor catalogDescriptor : this.catalogDescriptors) {
            if (!url.startsWith(catalogDescriptor.getUrl().toExternalForm())) continue;
            return catalogDescriptor;
        }
        return null;
    }
}

