/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.p2.ui.actions.UninstallAction;
import org.eclipse.equinox.internal.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.p2.ui.misc.StringMatcher;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.ICopyable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.menus.AbstractContributionFactory;

public class InstalledSoftwarePage
extends InstallationPage
implements ICopyable {
    private static final int UPDATE_ID = 1024;
    private static final int UNINSTALL_ID = 1025;
    private static final int PROPERTIES_ID = 1026;
    private static final String BUTTON_ACTION = "org.eclipse.equinox.p2.ui.buttonAction";
    AbstractContributionFactory factory;
    Text detailsArea;
    InstalledIUGroup installedIUGroup;
    String profileId;
    Button updateButton;
    Button uninstallButton;
    Button propertiesButton;
    ProvisioningUI ui;
    private Text filterText;

    public void createControl(Composite parent) {
        int width;
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.installed_software_context");
        this.profileId = this.getProvisioningUI().getProfileId();
        if (this.profileId == null) {
            IStatus status = this.getProvisioningUI().getPolicy().getNoProfileChosenStatus();
            if (status != null) {
                ProvUI.reportStatus(status, 1);
            }
            Text text = new Text(parent, 72);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(ProvUIMessages.InstalledSoftwarePage_NoProfile);
            this.setControl((Control)text);
            return;
        }
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = width = this.getDefaultWidth((Control)composite);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.filterText = new Text(composite, 2432);
        this.filterText.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.filterText.setMessage(ProvUIMessages.InstalledSoftwarePage_Filter_Installed_Software);
        this.filterText.setFocus();
        this.installedIUGroup = new InstalledIUGroup(this.getProvisioningUI(), composite, JFaceResources.getDialogFont(), this.profileId, this.getColumnConfig());
        CopyUtils.activateCopy(this, this.installedIUGroup.getStructuredViewer().getControl());
        gd = new GridData(4, 4, true, false);
        gd.heightHint = this.convertHeightInCharsToPixels(4);
        gd.widthHint = width;
        this.detailsArea = new Text(composite, 2890);
        this.detailsArea.setBackground(this.detailsArea.getDisplay().getSystemColor(25));
        this.detailsArea.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public void createPageButtons(Composite parent) {
        if (this.profileId == null) {
            return;
        }
        UpdateAction updateAction = new UpdateAction(this.getProvisioningUI(), new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                StructuredViewer viewer = InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer();
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    Object[] all = ((IStructuredContentProvider)viewer.getContentProvider()).getElements(viewer.getInput());
                    return new StructuredSelection(all);
                }
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().removeSelectionChangedListener(listener);
            }

            public void setSelection(ISelection selection) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().setSelection(selection);
            }
        }, this.profileId, true){

            @Override
            public void run() {
                super.run();
                if (this.getReturnCode() == 0) {
                    InstalledSoftwarePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        updateAction.setSkipSelectionPage(true);
        this.updateButton = this.createButton(parent, 1024, updateAction.getText());
        this.updateButton.setData(BUTTON_ACTION, (Object)updateAction);
        UninstallAction uninstallAction = new UninstallAction(this.getProvisioningUI(), (ISelectionProvider)this.installedIUGroup.getStructuredViewer(), this.profileId){

            @Override
            public void run() {
                super.run();
                if (this.getReturnCode() == 0) {
                    InstalledSoftwarePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        this.uninstallButton = this.createButton(parent, 1025, uninstallAction.getText());
        this.uninstallButton.setData(BUTTON_ACTION, (Object)uninstallAction);
        PropertyDialogAction action = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.installedIUGroup.getStructuredViewer());
        this.propertiesButton = this.createButton(parent, 1026, action.getText());
        this.propertiesButton.setData(BUTTON_ACTION, (Object)action);
        this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstalledSoftwarePage.this.updateDetailsArea();
                InstalledSoftwarePage.this.updateEnablement();
            }
        });
        final IUPatternFilter searchFilter = new IUPatternFilter(this.getColumnConfig());
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InstalledSoftwarePage.this.filterText != null && !InstalledSoftwarePage.this.filterText.isDisposed()) {
                    searchFilter.setPattern(InstalledSoftwarePage.this.filterText.getText());
                    InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().refresh();
                }
            }
        });
        this.installedIUGroup.getStructuredViewer().addFilter((ViewerFilter)searchFilter);
        this.updateEnablement();
    }

    void updateDetailsArea() {
        String description;
        List<IInstallableUnit> selected = this.installedIUGroup.getSelectedIUs();
        if (selected.size() == 1 && (description = selected.get(0).getProperty("org.eclipse.equinox.p2.description", null)) != null) {
            this.detailsArea.setText(description);
            return;
        }
        this.detailsArea.setText("");
    }

    void updateEnablement() {
        if (this.updateButton == null || this.updateButton.isDisposed()) {
            return;
        }
        Button[] buttons = new Button[]{this.updateButton, this.uninstallButton, this.propertiesButton};
        int i = 0;
        while (i < buttons.length) {
            Action action = (Action)buttons[i].getData(BUTTON_ACTION);
            if (action == null || !action.isEnabled()) {
                buttons[i].setEnabled(false);
            } else {
                buttons[i].setEnabled(true);
            }
            ++i;
        }
    }

    private IUColumnConfig[] getColumnConfig() {
        return new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20), new IUColumnConfig(ProvUIMessages.ProvUI_IdColumnTitle, 0, 40), new IUColumnConfig(ProvUIMessages.ProvUI_ProviderColumnTitle, 4, 40)};
    }

    private int getDefaultWidth(Control control) {
        IUColumnConfig[] columns = this.getColumnConfig();
        int totalWidth = 0;
        int i = 0;
        while (i < columns.length) {
            totalWidth += columns[i].getWidthInPixels(control);
            ++i;
        }
        return totalWidth + 20;
    }

    @Override
    public void copyToClipboard(Control activeControl) {
        Object[] elements = this.installedIUGroup.getSelectedIUElements();
        if (elements.length == 0) {
            return;
        }
        String text = CopyUtils.getIndentedClipboardText(elements, new IUDetailsLabelProvider(null, this.getColumnConfig(), null));
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                ((Action)this.updateButton.getData(BUTTON_ACTION)).run();
                break;
            }
            case 1025: {
                ((Action)this.uninstallButton.getData(BUTTON_ACTION)).run();
                break;
            }
            case 1026: {
                ((Action)this.propertiesButton.getData(BUTTON_ACTION)).run();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    ProvisioningUI getProvisioningUI() {
        if (this.ui == null) {
            this.ui = ProvisioningUI.getDefaultUI();
            return this.ui;
        }
        return this.ui;
    }

    public void setProvisioningUI(ProvisioningUI value) {
        this.ui = value;
    }

    class IUPatternFilter
    extends ViewerFilter {
        private StringMatcher matcher;
        private boolean filterOnId;
        private boolean filterOnName;
        private boolean filterOnProvider;

        public IUPatternFilter() {
            this(null);
        }

        public IUPatternFilter(IUColumnConfig[] columnConfig) {
            if (columnConfig == null) {
                columnConfig = ProvUI.getIUColumnConfig();
            }
            IUColumnConfig[] iUColumnConfigArray = columnConfig;
            int n = columnConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IUColumnConfig colConfig = iUColumnConfigArray[n2];
                switch (colConfig.getColumnType()) {
                    case 0: {
                        this.filterOnId = true;
                        break;
                    }
                    case 1: {
                        this.filterOnName = true;
                        break;
                    }
                    case 4: {
                        this.filterOnProvider = true;
                        break;
                    }
                }
                if (this.filterOnId && this.filterOnName && this.filterOnProvider) break;
                ++n2;
            }
        }

        public void setPattern(String searchPattern) {
            if (searchPattern == null || searchPattern.length() == 0) {
                this.matcher = null;
            } else {
                String pattern = "*" + searchPattern + "*";
                this.matcher = new StringMatcher(pattern, true, false);
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher == null || !this.filterOnName && !this.filterOnId && !this.filterOnProvider) {
                return true;
            }
            if (element instanceof InstalledIUElement) {
                InstalledIUElement data = (InstalledIUElement)element;
                IInstallableUnit iu = data.getIU();
                boolean match = false;
                if (iu != null) {
                    if (this.filterOnName) {
                        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                        match = this.matcher.match(name);
                    }
                    if (!match && this.filterOnId) {
                        match = this.matcher.match(iu.getId());
                    }
                    if (!match && this.filterOnProvider) {
                        String provider = iu.getProperty("org.eclipse.equinox.p2.provider", null);
                        match = this.matcher.match(provider);
                    }
                }
                return match;
            }
            return true;
        }
    }
}

