/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.core.selection;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.AbstractChromatogramSelection;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.notifier.ChromatogramSelectionWSDUpdateNotifier;

public class ChromatogramSelectionWSD
extends AbstractChromatogramSelection
implements IChromatogramSelectionWSD {
    private IScanWSD selectedScan;
    private IPeak selectedPeak;
    private IMarkedWavelengths selectedWavelengths;

    public ChromatogramSelectionWSD(IChromatogram chromatogram) throws ChromatogramIsNullException {
        this(chromatogram, true);
    }

    public ChromatogramSelectionWSD(IChromatogram chromatogram, boolean fireUpdate) throws ChromatogramIsNullException {
        super(chromatogram, fireUpdate);
        IChromatogramWSD wsdChromatogram = (IChromatogramWSD)chromatogram;
        IScanWSD scan = (IScanWSD)wsdChromatogram.getScans().stream().findFirst().get();
        this.selectedWavelengths = new MarkedWavelengths();
        for (IScanSignalWSD signal : scan.getScanSignals()) {
            this.selectedWavelengths.add(new MarkedWavelength(signal.getWavelength()));
        }
        this.reset(fireUpdate);
    }

    public void dispose() {
        this.selectedScan = null;
        this.selectedPeak = null;
        super.dispose();
    }

    @Override
    public IChromatogramWSD getChromatogramWSD() {
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram instanceof IChromatogramWSD) {
            return (IChromatogramWSD)chromatogram;
        }
        return null;
    }

    @Override
    public IScanWSD getSelectedScan() {
        return this.selectedScan;
    }

    public IPeak getSelectedPeak() {
        return this.selectedPeak;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean fireUpdate) {
        super.reset(fireUpdate);
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram.getNumberOfScans() >= 1) {
            if (chromatogram instanceof IChromatogramWSD) {
                this.selectedScan = ((IChromatogramWSD)chromatogram).getSupplierScan(1);
            }
        } else {
            this.selectedScan = null;
        }
        if (fireUpdate) {
            ChromatogramSelectionWSDUpdateNotifier.fireUpdateChange(this, false);
        }
    }

    public void setSelectedScan(IScan selectedScan) {
        if (selectedScan instanceof IScanWSD) {
            this.setSelectedScan((IScanWSD)selectedScan);
        }
    }

    public void setSelectedScan(IScan selectedScan, boolean update) {
        if (selectedScan instanceof IScanWSD) {
            this.setSelectedScan((IScanWSD)selectedScan, update);
        }
    }

    @Override
    public void setSelectedScan(IScanWSD selectedScan) {
        this.setSelectedScan(selectedScan, true);
    }

    @Override
    public void setSelectedScan(IScanWSD selectedScan, boolean update) {
        if (selectedScan != null) {
            this.selectedScan = selectedScan;
            if (update) {
                ChromatogramSelectionWSDUpdateNotifier.fireUpdateChange(this, false);
            }
        }
    }

    public void fireUpdateChange(boolean forceReload) {
        ChromatogramSelectionWSDUpdateNotifier.fireUpdateChange(this, forceReload);
    }

    public void update(boolean forceReload) {
        super.update(forceReload);
        this.setSelectedScan(this.selectedScan, false);
        this.fireUpdateChange(forceReload);
    }

    @Override
    public IMarkedWavelengths getSelectedWavelengths() {
        return this.selectedWavelengths;
    }
}

