/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.jcampdx.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.jcampdx.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectraReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(MassSpectraReader.class);
    private static final String HEADER_MARKER = "##";
    private static final String HEADER_TITLE = "##TITLE=";
    private static final String HEADER_VERSION = "##VERSION=";
    private static final String RETENTION_TIME_MARKER = "##RETENTION_TIME=";
    private static final String RETENTION_INDEX_MARKER = "##$RETENTION INDEX=";
    private static final String CAS_REGISTRY_NO = "##CAS REGISTRY NO=";
    private static final String CAS_NAME = "##CAS NAME=";
    private static final String MOL_WEIGHT = "##MW=";
    private static final String MOL_FORM = "##MOLFORM=";
    private static final String TIME_MARKER = "##TIME=";
    private static final String TITLE_MARKER = "##TITLE=";
    private static final String NAME_MARKER = "##NAME=";
    private static final String NAMES_MARKER = "##NAMES=";
    private static final String XYDATA_MARKER_SPACE_TYPE1 = "##XYDATA= (XY..XY)";
    private static final String XYDATA_MARKER_SPACE_TYPE2 = "##XYDATA=(XY..XY)";
    private static final String XYDATA_MARKER_SHORT = "##XYDATA=(X,Y)";
    private static final String PEAK_TABLE_MARKER = "##PEAK TABLE=(XY..XY)";
    private static final Pattern ionPattern = Pattern.compile("(\\d+\\.?\\d{0,5})(.*?)(\\d+\\.?\\d{0,5})");

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (this.isValidFileFormat(file)) {
            boolean isNameMarkerAvailable = this.isNameMarkerAvailable(file);
            return this.extractMassSpectra(file, isNameMarkerAvailable, monitor);
        }
        return null;
    }

    private IMassSpectra extractMassSpectra(File file, boolean isNameMarkerAvailable, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        String line;
        String referenceIdentifierMarker = PreferenceSupplier.getReferenceIdentifierMarker();
        String referenceIdentifierPrefix = PreferenceSupplier.getReferenceIdentifierPrefix();
        MassSpectra massSpectra = new MassSpectra();
        VendorLibraryMassSpectrum massSpectrum = null;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        boolean readIons = false;
        while ((line = bufferedReader.readLine()) != null) {
            if (this.addNewMassSpectrum(line, isNameMarkerAvailable)) {
                String name = isNameMarkerAvailable ? (line.startsWith(NAME_MARKER) ? line.replace(NAME_MARKER, "").trim() : line.replace(NAMES_MARKER, "").trim()) : line.replace("##TITLE=", "").trim();
                if (massSpectrum != null && massSpectrum.getIons().size() > 0) {
                    massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
                }
                massSpectrum = new VendorLibraryMassSpectrum();
                LibraryInformation libraryInformation = new LibraryInformation();
                libraryInformation.setName(name);
                libraryInformation.setComments("JCAMP-DX");
                massSpectrum.setLibraryInformation((ILibraryInformation)libraryInformation);
                readIons = false;
                continue;
            }
            if (massSpectrum == null) continue;
            if (line.startsWith(RETENTION_TIME_MARKER) || line.startsWith(TIME_MARKER)) {
                int retentionTime = this.getRetentionTime(line);
                massSpectrum.setRetentionTime(retentionTime);
                continue;
            }
            if (line.startsWith(RETENTION_INDEX_MARKER)) {
                float retentionIndex = this.getRetentionIndex(line);
                massSpectrum.setRetentionIndex(retentionIndex);
                continue;
            }
            if (line.startsWith(CAS_REGISTRY_NO)) {
                String casNumber = line.replace(CAS_REGISTRY_NO, "").trim();
                massSpectrum.getLibraryInformation().setCasNumber(casNumber);
                continue;
            }
            if (line.startsWith(CAS_NAME)) {
                String name = line.replace(CAS_NAME, "").trim();
                this.extractNameAndReferenceIdentifier(massSpectrum, name, referenceIdentifierMarker, referenceIdentifierPrefix);
                continue;
            }
            if (line.startsWith(MOL_WEIGHT)) {
                double molWeight = this.getMolWeight(line);
                massSpectrum.getLibraryInformation().setMolWeight(molWeight);
                continue;
            }
            if (line.startsWith(MOL_FORM)) {
                String formula = line.replace(MOL_FORM, "").trim();
                massSpectrum.getLibraryInformation().setFormula(formula);
                continue;
            }
            if (line.startsWith(XYDATA_MARKER_SPACE_TYPE1) || line.startsWith(XYDATA_MARKER_SPACE_TYPE2) || line.startsWith(XYDATA_MARKER_SHORT) || line.startsWith(PEAK_TABLE_MARKER)) {
                readIons = true;
                continue;
            }
            if (line.startsWith(HEADER_MARKER) || !readIons) continue;
            try {
                line = line.trim();
                Matcher ions = ionPattern.matcher(line.trim());
                while (ions.find()) {
                    double mz = Double.parseDouble(ions.group(1));
                    float abundance = Float.parseFloat(ions.group(3));
                    if (!(abundance >= Float.MIN_VALUE) || !(abundance <= Float.MAX_VALUE)) continue;
                    VendorIon ion = new VendorIon(mz, abundance);
                    massSpectrum.addIon((IIon)ion);
                }
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
        }
        if (massSpectrum != null && massSpectrum.getIons().size() > 0) {
            massSpectra.addMassSpectrum(massSpectrum);
        }
        massSpectra.setName(file.getName());
        massSpectra.setConverterId("org.eclipse.chemclipse.msd.converter.supplier.jcampdx.library");
        bufferedReader.close();
        fileReader.close();
        return massSpectra;
    }

    private boolean addNewMassSpectrum(String line, boolean isNameMarkerAvailable) {
        return isNameMarkerAvailable ? line.startsWith(NAME_MARKER) || line.startsWith(NAMES_MARKER) : line.startsWith("##TITLE=");
    }

    private int getRetentionTime(String line) {
        int retentionTime = 0;
        try {
            if (line.startsWith(RETENTION_TIME_MARKER)) {
                String value = line.replace(RETENTION_TIME_MARKER, "").trim();
                retentionTime = (int)(Double.parseDouble(value) * 1000.0);
            } else if (line.startsWith(TIME_MARKER)) {
                String value = line.replace(TIME_MARKER, "").trim();
                retentionTime = (int)(Double.parseDouble(value) * 60000.0);
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return retentionTime;
    }

    private float getRetentionIndex(String line) {
        float retentionIndex = 0.0f;
        try {
            if (line.startsWith(RETENTION_INDEX_MARKER)) {
                String value = line.replace(RETENTION_INDEX_MARKER, "").trim();
                retentionIndex = (float)Double.parseDouble(value);
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return retentionIndex;
    }

    private double getMolWeight(String line) {
        double molWeight = 0.0;
        try {
            if (line.startsWith(MOL_WEIGHT)) {
                String value = line.replace(MOL_WEIGHT, "").trim();
                molWeight = Double.parseDouble(value);
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return molWeight;
    }

    private boolean isValidFileFormat(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        bufferedReader.close();
        fileReader.close();
        return line.startsWith("##TITLE=") || line.startsWith(HEADER_VERSION);
    }

    private boolean isNameMarkerAvailable(File file) throws IOException {
        String line;
        boolean nameMarkerAvailable = false;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((line = bufferedReader.readLine()) != null) {
            if (!line.startsWith(NAME_MARKER) && !line.startsWith(NAMES_MARKER)) continue;
            nameMarkerAvailable = true;
            break;
        }
        bufferedReader.close();
        fileReader.close();
        return nameMarkerAvailable;
    }
}

