/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumSearchListUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.msd.swt.ui.support.MassSpectrumFileSupport;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.IListItemsRemoveListener;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MassSpectraIdentifiedList
extends AbstractChromatogramSelectionMSDView {
    private static final Logger logger = Logger.getLogger(MassSpectraIdentifiedList.class);
    @Inject
    private Composite parent;
    private MassSpectrumSearchListUI massSpectrumListUI;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    private IChromatogramSelectionMSD chromatogramSelection;

    @Inject
    public MassSpectraIdentifiedList(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.eventBroker = eventBroker;
        if (eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    MassSpectraIdentifiedList.this.update(MassSpectraIdentifiedList.this.getChromatogramSelection(), true);
                }
            };
            eventBroker.subscribe("chromatogram/msd/update/massspectrum", this.eventHandler);
        }
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(this.parent, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite compositeButtons = new Composite(composite, 0);
        GridData gridDataComposite = new GridData(768);
        gridDataComposite.horizontalAlignment = 0x1000008;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        compositeButtons.setLayout((Layout)new GridLayout(1, false));
        Button saveButton = new Button(compositeButtons, 8);
        saveButton.setImage(ApplicationImageFactory.getInstance().getImage("saveas.gif", "16x16"));
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (MassSpectraIdentifiedList.this.chromatogramSelection != null) {
                        IMassSpectra massSpectra = SeriesConverterMSD.getIdentifiedScans((IChromatogramSelectionMSD)MassSpectraIdentifiedList.this.chromatogramSelection, (boolean)true);
                        MassSpectrumFileSupport.saveMassSpectra((IMassSpectra)massSpectra);
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        this.massSpectrumListUI = new MassSpectrumSearchListUI(composite, 0);
        this.massSpectrumListUI.setLayoutData((Object)new GridData(1808));
        this.massSpectrumListUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null && firstElement instanceof IVendorMassSpectrum) {
                    ArrayList<String> viewIds = new ArrayList<String>();
                    viewIds.add("org.eclipse.chemclipse.ux.extension.msd.ui.part.simpleOptimizedNominalMassSpectrumView");
                    viewIds.add("org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumTargetsView");
                    PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.main", viewIds);
                    IVendorMassSpectrum vendorMassSpectrum = (IVendorMassSpectrum)firstElement;
                    MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)vendorMassSpectrum, (boolean)true);
                    MassSpectraIdentifiedList.this.chromatogramSelection.setSelectedIdentifiedScan(vendorMassSpectrum, false);
                    ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)MassSpectraIdentifiedList.this.chromatogramSelection, (boolean)true);
                    MassSpectraIdentifiedList.this.massSpectrumListUI.setFocus();
                }
            }
        });
        this.massSpectrumListUI.addListItemsRemoveListener(new IListItemsRemoveListener(){

            public void update() {
                ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)MassSpectraIdentifiedList.this.chromatogramSelection, (boolean)true);
            }
        });
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.massSpectrumListUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void unsubscribe() {
        super.unsubscribe();
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    @Override
    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection)) {
            this.chromatogramSelection = chromatogramSelection;
            IMassSpectra massSpectra = SeriesConverterMSD.getIdentifiedScans((IChromatogramSelectionMSD)chromatogramSelection, (boolean)true);
            this.massSpectrumListUI.update(massSpectra, forceReload);
        }
    }
}

