/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.ChromatogramExportRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramFileSupport {
    private static final Logger logger = Logger.getLogger(ChromatogramFileSupport.class);

    private ChromatogramFileSupport() {
    }

    public static boolean saveChromatogram(IChromatogramMSD chromatogram) throws NoConverterAvailableException {
        Shell shell = Display.getDefault().getActiveShell();
        if (chromatogram == null || shell == null) {
            return false;
        }
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterPath(Activator.getDefault().getSettingsPath());
        dialog.setFileName(chromatogram.getName());
        dialog.setText("Save Chromatogram As");
        dialog.setOverwrite(true);
        ChromatogramConverterSupport converterSupport = ChromatogramConverterMSD.getChromatogramConverterSupport();
        String[] filterExtensions = converterSupport.getExportableFilterExtensions();
        dialog.setFilterExtensions(filterExtensions);
        String[] filterNames = converterSupport.getExportableFilterNames();
        dialog.setFilterNames(filterNames);
        String filename = dialog.open();
        if (filename != null) {
            ChromatogramFileSupport.validateFile(dialog, converterSupport.getExportSupplier(), shell, converterSupport, chromatogram);
            return true;
        }
        return false;
    }

    public static void writeFile(File file, IChromatogramMSD chromatogram, ISupplier supplier) {
        if (file == null || chromatogram == null || supplier == null) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        ChromatogramExportRunnable runnable = new ChromatogramExportRunnable(file, chromatogram, supplier);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        File data = runnable.getData();
        if (data == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Save Chromatogram", (String)"There is not suitable chromatogram converter available.");
        }
    }

    private static void validateFile(FileDialog dialog, List<ISupplier> supplier, Shell shell, ChromatogramConverterSupport converterSupport, IChromatogramMSD chromatogram) {
        File chromatogramFolder = null;
        boolean overwrite = dialog.getOverwrite();
        boolean folderExists = false;
        boolean isDirectory = false;
        ISupplier selectedSupplier = supplier.get(dialog.getFilterIndex());
        if (selectedSupplier == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Chromatogram Converter", (String)"The requested chromatogram converter does not exists.");
            return;
        }
        String filename = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
        if (selectedSupplier != null) {
            String directoryExtension = selectedSupplier.getDirectoryExtension();
            if (directoryExtension != "") {
                isDirectory = true;
                filename = ChromatogramFileSupport.removeFileExtensions(filename, selectedSupplier);
                chromatogramFolder = new File(filename = filename.concat(selectedSupplier.getDirectoryExtension()));
                if (chromatogramFolder.exists()) {
                    folderExists = true;
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the chromatogram " + chromatogramFolder.toString() + "?"));
                }
                if (overwrite && !folderExists) {
                    chromatogramFolder.mkdir();
                }
            } else {
                File chromatogramFile;
                String filenameDialog;
                filename = ChromatogramFileSupport.removeFileExtensions(filename, selectedSupplier);
                if (!(filename = filename.concat(selectedSupplier.getFileExtension())).equals(filenameDialog = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName()) && (chromatogramFile = new File(filename)).exists()) {
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the chromatogram " + chromatogramFile.toString() + "?"));
                }
            }
            if (overwrite) {
                if (isDirectory) {
                    if (!folderExists && chromatogramFolder != null) {
                        chromatogramFolder.mkdir();
                    }
                } else {
                    String fileExtension = selectedSupplier.getFileExtension();
                    if (!filename.endsWith(fileExtension)) {
                        filename = String.valueOf(filename) + fileExtension;
                    }
                }
                ChromatogramFileSupport.writeFile(new File(filename), chromatogram, selectedSupplier);
            }
        }
    }

    private static String removeFileExtensions(String filePath, ISupplier supplier) {
        int start = 0;
        int stop = 0;
        if (supplier.getDirectoryExtension().equals("")) {
            String fileExtension = supplier.getFileExtension();
            if (filePath.endsWith(fileExtension) || filePath.endsWith(fileExtension.toLowerCase()) || filePath.endsWith(fileExtension.toUpperCase())) {
                stop = filePath.length() - fileExtension.length();
                filePath = filePath.substring(start, stop);
            }
        } else {
            String directoryExtension = supplier.getDirectoryExtension();
            if (filePath.endsWith(directoryExtension) || filePath.endsWith(directoryExtension.toLowerCase()) || filePath.endsWith(directoryExtension.toUpperCase())) {
                stop = filePath.length() - directoryExtension.length();
                filePath = filePath.substring(start, stop);
            }
        }
        return filePath;
    }
}

