/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixDimensionException;

public class MatrixVectorMult {
    public static void mult(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numCols != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numCols != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A.numCols == 0) {
            CommonOps.fill(C, 0.0);
            return;
        }
        int indexA = 0;
        int cIndex = 0;
        double b0 = B.get(0);
        int i = 0;
        while (i < A.numRows) {
            double total = A.get(indexA++) * b0;
            int j = 1;
            while (j < A.numCols) {
                total += A.get(indexA++) * B.get(j);
                ++j;
            }
            C.set(cIndex++, total);
            ++i;
        }
    }

    public static void multAdd(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numCols != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numCols != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A.numCols == 0) {
            return;
        }
        int indexA = 0;
        int cIndex = 0;
        int i = 0;
        while (i < A.numRows) {
            double total = A.get(indexA++) * B.get(0);
            int j = 1;
            while (j < A.numCols) {
                total += A.get(indexA++) * B.get(j);
                ++j;
            }
            C.plus(cIndex++, total);
            ++i;
        }
    }

    public static void multTransA_small(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int cIndex = 0;
        int i = 0;
        while (i < A.numCols) {
            double total = 0.0;
            int indexA = i;
            int j = 0;
            while (j < A.numRows) {
                total += A.get(indexA) * B.get(j);
                indexA += A.numCols;
                ++j;
            }
            C.set(cIndex++, total);
            ++i;
        }
    }

    public static void multTransA_reorder(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A.numRows == 0) {
            CommonOps.fill(C, 0.0);
            return;
        }
        double B_val = B.get(0);
        int i = 0;
        while (i < A.numCols) {
            C.set(i, A.get(i) * B_val);
            ++i;
        }
        int indexA = A.numCols;
        int i2 = 1;
        while (i2 < A.numRows) {
            B_val = B.get(i2);
            int j = 0;
            while (j < A.numCols) {
                C.plus(j, A.get(indexA++) * B_val);
                ++j;
            }
            ++i2;
        }
    }

    public static void multAddTransA_small(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int cIndex = 0;
        int i = 0;
        while (i < A.numCols) {
            double total = 0.0;
            int indexA = i;
            int j = 0;
            while (j < A.numRows) {
                total += A.get(indexA) * B.get(j);
                indexA += A.numCols;
                ++j;
            }
            C.plus(cIndex++, total);
            ++i;
        }
    }

    public static void multAddTransA_reorder(RowD1Matrix64F A, D1Matrix64F B, D1Matrix64F C) {
        if (C.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B.numRows == 1) {
            if (A.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A.numRows == 0) {
            return;
        }
        int indexA = 0;
        int j = 0;
        while (j < A.numRows) {
            double B_val = B.get(j);
            int i = 0;
            while (i < A.numCols) {
                C.plus(i, A.get(indexA++) * B_val);
                ++i;
            }
            ++j;
        }
    }
}

