/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.core.PeakMaxPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.support.IPeakMaxPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakMaxPeakIntegratorSupport
implements IPeakMaxPeakIntegratorSupport {
    @Override
    public IPeakIntegrationResults calculatePeakIntegrationResults(List<IPeakMSD> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        monitor.subTask("Integrate the peaks");
        PeakMaxPeakIntegrator peakIntegrator = new PeakMaxPeakIntegrator();
        IPeakIntegrationResults peakIntegrationResults = peakIntegrator.integrate(peaks, peakIntegrationSettings, monitor);
        return peakIntegrationResults;
    }

    @Override
    public IPeakIntegrationResults calculatePeakIntegrationResults(IChromatogramSelectionMSD chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        List peaks = chromatogram.getPeaks(chromatogramSelection);
        ArrayList<IPeakMSD> peakList = new ArrayList<IPeakMSD>();
        for (IChromatogramPeakMSD chromatogramPeak : peaks) {
            peakList.add((IPeakMSD)chromatogramPeak);
        }
        return this.calculatePeakIntegrationResults(peakList, peakIntegrationSettings, monitor);
    }

    @Override
    public IPeakIntegrationResult calculatePeakIntegrationResult(IPeakMSD peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        monitor.subTask("Integrate the peak");
        PeakMaxPeakIntegrator peakIntegrator = new PeakMaxPeakIntegrator();
        IPeakIntegrationResult peakIntegrationResult = peakIntegrator.integrate(peak, peakIntegrationSettings, monitor);
        return peakIntegrationResult;
    }
}

