/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.quantitation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.equations.QuadraticEquation;

public abstract class AbstractConcentrationResponseEntriesMSD
implements IConcentrationResponseEntriesMSD {
    private static final long serialVersionUID = 163932807502826445L;
    private List<IConcentrationResponseEntryMSD> concentrationResponseEntries = new ArrayList<IConcentrationResponseEntryMSD>();

    @Override
    public void add(IConcentrationResponseEntryMSD concentrationResponseEntry) {
        this.concentrationResponseEntries.add(concentrationResponseEntry);
    }

    @Override
    public void addAll(List<IConcentrationResponseEntryMSD> concentrationResponseEntries) {
        this.concentrationResponseEntries.addAll(concentrationResponseEntries);
    }

    @Override
    public void remove(IConcentrationResponseEntryMSD concentrationResponseEntry) {
        this.concentrationResponseEntries.remove(concentrationResponseEntry);
    }

    @Override
    public void removeAll(List<IConcentrationResponseEntryMSD> concentrationResponseEntriesMSD) {
        this.concentrationResponseEntries.removeAll(concentrationResponseEntriesMSD);
    }

    @Override
    public void clear() {
        this.concentrationResponseEntries.clear();
    }

    @Override
    public int size() {
        return this.concentrationResponseEntries.size();
    }

    @Override
    public IConcentrationResponseEntryMSD get(int index) {
        return this.concentrationResponseEntries.get(index);
    }

    @Override
    public List<IConcentrationResponseEntryMSD> getList() {
        return this.concentrationResponseEntries;
    }

    @Override
    public LinearEquation getLinearEquation(double ion, boolean isCrossZero) {
        List<IPoint> points = this.getPoints(ion, isCrossZero);
        IPoint[] pointArray = points.toArray(new IPoint[points.size()]);
        LinearEquation linearEquation = Equations.createLinearEquation((IPoint[])pointArray);
        return linearEquation;
    }

    @Override
    public QuadraticEquation getQuadraticEquation(double ion, boolean isCrossZero) {
        List<IPoint> points = this.getPoints(ion, isCrossZero);
        IPoint[] pointArray = points.toArray(new IPoint[points.size()]);
        QuadraticEquation quadraticEquation = Equations.createQuadraticEquation((IPoint[])pointArray);
        return quadraticEquation;
    }

    @Override
    public double getAverageFactor(double ion, boolean isCrossZero) {
        double x = 0.0;
        double y = 0.0;
        List<IPoint> points = this.getPoints(ion, isCrossZero);
        int size = points.size();
        if (size == 0) {
            return 0.0;
        }
        for (IPoint point : points) {
            x += point.getX();
            y += point.getY();
        }
        x /= (double)size;
        if ((y /= (double)size) == 0.0) {
            return 0.0;
        }
        return x / y;
    }

    private List<IPoint> getPoints(double ion, boolean isCrossZero) {
        ArrayList<IPoint> points = new ArrayList<IPoint>();
        if (isCrossZero) {
            points.add((IPoint)new Point(0.0, 0.0));
        }
        for (IConcentrationResponseEntryMSD entry : this.concentrationResponseEntries) {
            if (ion != entry.getIon()) continue;
            points.add((IPoint)new Point(entry.getConcentration(), entry.getResponse()));
        }
        return points;
    }

    @Override
    public double getMaxResponseValue() {
        double maxResponse = 0.0;
        for (IConcentrationResponseEntryMSD entry : this.concentrationResponseEntries) {
            double response = entry.getResponse();
            if (!(response > maxResponse)) continue;
            maxResponse = response;
        }
        return maxResponse;
    }

    @Override
    public Set<Double> getIonSet() {
        HashSet<Double> ionSet = new HashSet<Double>();
        for (IConcentrationResponseEntryMSD entry : this.concentrationResponseEntries) {
            ionSet.add(entry.getIon());
        }
        return ionSet;
    }

    @Override
    public List<IConcentrationResponseEntryMSD> getList(double ion) {
        ArrayList<IConcentrationResponseEntryMSD> entries = new ArrayList<IConcentrationResponseEntryMSD>();
        for (IConcentrationResponseEntryMSD entry : this.concentrationResponseEntries) {
            if (entry.getIon() != ion) continue;
            entries.add(entry);
        }
        return entries;
    }
}

