/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExtendedTableViewer
extends TableViewer {
    private Clipboard clipboard = new Clipboard(Display.getDefault());
    private final String DELIMITER = "\t";
    private final String COPY_TO_CLIPBOARD = "Copy selection to clipboard";
    private final String POPUP_MENU_ID = "org.eclipse.chemclipse.swt.ui.viewers.extendedTableViewer.popup";
    private List<TableViewerColumn> tableViewerColumns = new ArrayList<TableViewerColumn>();

    public ExtendedTableViewer(Composite parent) {
        this(parent, 66306);
        this.clipboard = new Clipboard(Display.getDefault());
        this.tableViewerColumns = new ArrayList<TableViewerColumn>();
    }

    public ExtendedTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void addCopyToClipboardListener(final String[] titles) {
        this.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 99) {
                    ExtendedTableViewer.this.copyToClipboard(titles);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu(titles);
    }

    private void initContextMenu(final String[] titles) {
        MenuManager menuManager = new MenuManager("#PopUpMenu", "org.eclipse.chemclipse.swt.ui.viewers.extendedTableViewer.popup");
        Table table = this.getTable();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        ExtendedTableViewer.this.copyToClipboard(titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    public void copyToClipboard(String[] titles) {
        StringBuilder builder = new StringBuilder();
        int size = titles.length;
        String[] stringArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            builder.append(title);
            builder.append("\t");
            ++n2;
        }
        builder.append(OperatingSystemUtils.getLineDelimiter());
        Table table = this.getTable();
        int[] nArray = table.getSelectionIndices();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int index = nArray[n4];
            TableItem selection = table.getItem(index);
            int columnIndex = 0;
            while (columnIndex < size) {
                builder.append(selection.getText(columnIndex));
                builder.append("\t");
                ++columnIndex;
            }
            builder.append(OperatingSystemUtils.getLineDelimiter());
            ++n4;
        }
        if (builder.length() == 0) {
            builder.append("Please select one or more entries in the list.");
            builder.append(OperatingSystemUtils.getLineDelimiter());
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }

    public void createColumns(String[] titles, int[] bounds) {
        final Table table = this.getTable();
        table.setRedraw(false);
        this.tableViewerColumns.clear();
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        this.refresh();
        int i = 0;
        while (i < titles.length) {
            final int index = i;
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
            this.tableViewerColumns.add(tableViewerColumn);
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewerComparator viewerComparator = ExtendedTableViewer.this.getComparator();
                    if (viewerComparator instanceof IRecordTableComparator) {
                        IRecordTableComparator recordTableComparator = (IRecordTableComparator)viewerComparator;
                        recordTableComparator.setColumn(index);
                        int direction = table.getSortDirection();
                        direction = table.getSortColumn() == tableColumn ? (direction == 128 ? 1024 : 128) : 128;
                        table.setSortDirection(direction);
                        table.setSortColumn(tableColumn);
                        ExtendedTableViewer.this.refresh();
                    }
                }
            });
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public List<TableViewerColumn> getTableViewerColumns() {
        return this.tableViewerColumns;
    }
}

