/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support;

import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.exceptions.FilterException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.implementation.CombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.support.CombinedMassSpectrumCalculator;
import org.eclipse.chemclipse.msd.model.support.ICombinedMassSpectrumCalculator;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class CalculatorSupport {
    private static final Logger logger = Logger.getLogger(CalculatorSupport.class);
    private static final float NORMALIZATION_FACTOR = 1000.0f;
    private SegmentValidator segmentValidator = new SegmentValidator();

    public boolean acceptSegment(double[] values, double mean) {
        return this.segmentValidator.acceptSegment(values, mean);
    }

    public ICombinedMassSpectrumCalculator getCombinedMassSpectrumCalculator(IAnalysisSegment analysisSegment, IExtractedIonSignals extractedIonSignals) {
        CombinedMassSpectrumCalculator combinedMassSpectrumCalculator = new CombinedMassSpectrumCalculator();
        int scan = analysisSegment.getStartScan();
        while (scan <= analysisSegment.getStopScan()) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                int ion = extractedIonSignal.getStartIon();
                while (ion <= extractedIonSignal.getStopIon()) {
                    combinedMassSpectrumCalculator.addIon((double)ion, extractedIonSignal.getAbundance(ion));
                    ++ion;
                }
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return combinedMassSpectrumCalculator;
    }

    public ICombinedMassSpectrum getNoiseMassSpectrum(ICombinedMassSpectrumCalculator combinedMassSpectrumCalculator, IMarkedIons ionsToPreserve, IProgressMonitor monitor) {
        combinedMassSpectrumCalculator.removeIons(ionsToPreserve);
        combinedMassSpectrumCalculator.normalize(1000.0f);
        CombinedMassSpectrum noiseMassSpectrum = new CombinedMassSpectrum();
        Map ions = combinedMassSpectrumCalculator.getValues();
        for (Integer ion : ions.keySet()) {
            float abundance = ((Double)ions.get(ion)).floatValue();
            if (!(abundance > 0.0f)) continue;
            try {
                Ion noiseIon = new Ion((double)ion.intValue(), abundance);
                noiseMassSpectrum.addIon((IIon)noiseIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return noiseMassSpectrum;
    }

    public void checkScanRange(ScanRange scanRange, int segmentWidth) throws FilterException {
        if (scanRange == null || scanRange.getWidth() <= segmentWidth) {
            throw new FilterException("The selected scan width is lower than the segment width.");
        }
    }
}

