/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.support;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumLibraryInformation;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumTarget;

public class TargetBuilder {
    private static final Logger logger = Logger.getLogger(TargetBuilder.class);
    private static final String UNKNOWN = "???";
    private static final float MAX_FACTOR = 100.0f;
    private IonAbundanceComparator ionAbundanceComparator = new IonAbundanceComparator(SortOrder.DESC);

    public IPeakTarget getPeakTarget(IScanMSD reference, IMassSpectrumComparisonResult comparisonResult, String identifier) {
        return this.getPeakTarget(reference, comparisonResult, identifier, "");
    }

    public IPeakTarget getPeakTarget(IScanMSD reference, IMassSpectrumComparisonResult comparisonResult, String identifier, String database) {
        PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
        this.initializeLibraryInformation((ILibraryInformation)libraryInformation, reference);
        libraryInformation.setDatabase(database);
        PeakTarget peakTarget = null;
        try {
            peakTarget = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
            peakTarget.setIdentifier(identifier);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return peakTarget;
    }

    public void setPeakTargetUnknown(IPeakMSD peakMSD, String identifier) {
        try {
            IPeakMassSpectrum unknown = peakMSD.getExtractedMassSpectrum();
            ILibraryInformation libraryInformation = this.getLibraryInformationUnknown(unknown.getIons());
            IComparisonResult comparisonResult = this.getComparisonResultUnknown();
            PeakTarget peakTarget = new PeakTarget(libraryInformation, comparisonResult);
            peakTarget.setIdentifier(identifier);
            peakMSD.addTarget((IPeakTarget)peakTarget);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
    }

    public IMassSpectrumTarget getMassSpectrumTarget(IScanMSD reference, IMassSpectrumComparisonResult comparisonResult, String identifier) {
        return this.getMassSpectrumTarget(reference, comparisonResult, identifier, "");
    }

    public IMassSpectrumTarget getMassSpectrumTarget(IScanMSD reference, IMassSpectrumComparisonResult comparisonResult, String identifier, String database) {
        MassSpectrumLibraryInformation libraryInformation = new MassSpectrumLibraryInformation();
        this.initializeLibraryInformation((ILibraryInformation)libraryInformation, reference);
        libraryInformation.setDatabase(database);
        MassSpectrumTarget identificationEntry = null;
        try {
            identificationEntry = new MassSpectrumTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
            identificationEntry.setIdentifier(identifier);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return identificationEntry;
    }

    public void setMassSpectrumTargetUnknown(IScanMSD unknown, String identifier) {
        try {
            ILibraryInformation libraryInformation = this.getLibraryInformationUnknown(unknown.getIons());
            IComparisonResult comparisonResult = this.getComparisonResultUnknown();
            MassSpectrumTarget massSpectrumTarget = new MassSpectrumTarget(libraryInformation, comparisonResult);
            massSpectrumTarget.setIdentifier(identifier);
            unknown.addTarget((IMassSpectrumTarget)massSpectrumTarget);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
    }

    private void initializeLibraryInformation(ILibraryInformation libraryInformation, IScanMSD reference) {
        if (reference instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)reference;
            ILibraryInformation libraryInformationReference = libraryMassSpectrum.getLibraryInformation();
            libraryInformation.setName(libraryInformationReference.getName());
            libraryInformation.setCasNumber(libraryInformationReference.getCasNumber());
            libraryInformation.setMiscellaneous(libraryInformationReference.getComments());
            libraryInformation.setSmiles(libraryInformationReference.getSmiles());
            libraryInformation.setReferenceIdentifier(libraryInformationReference.getReferenceIdentifier());
        } else {
            libraryInformation.setName(UNKNOWN);
            libraryInformation.setCasNumber(UNKNOWN);
            libraryInformation.setMiscellaneous(UNKNOWN);
        }
    }

    private ILibraryInformation getLibraryInformationUnknown(List<IIon> ions) {
        LibraryInformation libraryInformation = new LibraryInformation();
        Collections.sort(ions, this.ionAbundanceComparator);
        StringBuilder builder = new StringBuilder();
        builder.append("Unknown [");
        int size = ions.size() >= 5 ? 5 : ions.size();
        int i = 0;
        while (i < size) {
            builder.append((int)ions.get(i).getIon());
            if (i < size - 1) {
                builder.append(",");
            }
            ++i;
        }
        builder.append("]");
        libraryInformation.setName(builder.toString());
        return libraryInformation;
    }

    private IComparisonResult getComparisonResultUnknown() {
        return new ComparisonResult(100.0f, 100.0f, 100.0f, 100.0f);
    }
}

