/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.IChemClipseChromatogramReportSettings;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.comparator.ChromatogramPeakCSDComparator;
import org.eclipse.chemclipse.model.comparator.ChromatogramPeakComparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReport {
    private static final int NUMBER_OF_IONS_TO_PRINT = 5;
    private static final String DELIMITER = "\t";
    private static final String ION_DELIMITER = " ";
    private static final String RESULTS_DELIMITER = "---";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private DateFormat dateFormat = ValueFormat.getDateFormatEnglish();

    public void generate(File file, boolean append, List<IChromatogram> chromatograms, IChemClipseChromatogramReportSettings chromatogramReportSettings, IProgressMonitor monitor) throws IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        printWriter.println("ASCII Report");
        printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        for (IChromatogram chromatogram : chromatograms) {
            this.printHeader(printWriter, (IChromatogramOverview)chromatogram, monitor);
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                this.reportChromatogram(printWriter, chromatogramMSD, monitor);
                continue;
            }
            if (chromatogram instanceof IChromatogramCSD) {
                IChromatogramCSD chromatogramFID = (IChromatogramCSD)chromatogram;
                this.reportChromatogram(printWriter, chromatogramFID, monitor);
                continue;
            }
            printWriter.println("There is no suitable report for the chromatogram available.");
        }
        printWriter.flush();
        fileWriter.flush();
        printWriter.close();
        fileWriter.close();
    }

    private void printHeader(PrintWriter printWriter, IChromatogramOverview chromatogramOverview, IProgressMonitor monitor) {
        this.printHeaderLine(printWriter, "Name", chromatogramOverview.getName());
        this.printHeaderLine(printWriter, "Data Name", chromatogramOverview.getDataName());
        this.printHeaderLine(printWriter, "Operator", chromatogramOverview.getOperator());
        Date date = chromatogramOverview.getDate();
        if (date != null) {
            this.printHeaderLine(printWriter, "Date", this.dateFormat.format(chromatogramOverview.getDate()));
        } else {
            this.printHeaderLine(printWriter, "Date", "");
        }
        this.printHeaderLine(printWriter, "Info", chromatogramOverview.getShortInfo());
        this.printHeaderLine(printWriter, "Misc", chromatogramOverview.getMiscInfo());
        this.printHeaderLine(printWriter, "Misc (separated)", chromatogramOverview.getMiscInfoSeparated());
        this.printHeaderLine(printWriter, "Details", chromatogramOverview.getDetailedInfo());
        this.printHeaderLine(printWriter, "Scans", Integer.toString(chromatogramOverview.getNumberOfScans()));
        this.printHeaderLine(printWriter, "Start RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStartRetentionTime() / 60000.0));
        this.printHeaderLine(printWriter, "Stop RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStopRetentionTime() / 60000.0));
        this.printHeaderLine(printWriter, "Barcode", chromatogramOverview.getBarcode());
        printWriter.println("------------------------------");
    }

    private void printHeaderLine(PrintWriter printWriter, String key, String value) {
        printWriter.print(key);
        printWriter.print(": ");
        printWriter.println(value);
    }

    private void reportChromatogram(PrintWriter printWriter, IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        List peaks = chromatogram.getPeaks();
        Collections.sort(peaks, new ChromatogramPeakComparator(SortOrder.ASC));
        printWriter.println("");
        printWriter.println("NAME: " + chromatogram.getName());
        printWriter.println("TYPE: MSD");
        printWriter.println("------------------------------");
        printWriter.println("Integrated Chromatogram Area: " + this.decimalFormat.format(chromatogram.getChromatogramIntegratedArea()));
        printWriter.println("Integrated Background Area: " + this.decimalFormat.format(chromatogram.getBackgroundIntegratedArea()));
        printWriter.println("Integrated Peak Area: " + this.decimalFormat.format(chromatogram.getPeakIntegratedArea()));
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK LIST OVERVIEW");
        printWriter.println("------------------------------");
        this.reportPeakListMSDOverview(printWriter, peaks, "Peaks are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakListIntegrationResults(printWriter, peaks, "Peak integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("SCAN IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportScanIdentificationResults(printWriter, chromatogram, "Scan identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakListIdentificationResults(printWriter, peaks, "Peak identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("BACKGROUND INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportIntegrationResults(printWriter, chromatogram.getBackgroundIntegrationEntries(), "Background integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("CHROMATOGRAM INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportIntegrationResults(printWriter, chromatogram.getChromatogramIntegrationEntries(), "Chromatogram integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("CHROMATOGRAM IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportChromatogramIdentificationResults(printWriter, chromatogram, "Chromatogram identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK QUANTITATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakListQuantitationResults(printWriter, peaks, "Peak quantitation results are not available.", monitor);
        printWriter.println("");
        printWriter.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    private void reportChromatogram(PrintWriter printWriter, IChromatogramCSD chromatogram, IProgressMonitor monitor) {
        List peaks = chromatogram.getPeaks();
        Collections.sort(peaks, new ChromatogramPeakCSDComparator(SortOrder.ASC));
        printWriter.println("");
        printWriter.println("NAME: " + chromatogram.getName());
        printWriter.println("TYPE: FID");
        printWriter.println("------------------------------");
        printWriter.println("Integrated Chromatogram Area: " + this.decimalFormat.format(chromatogram.getChromatogramIntegratedArea()));
        printWriter.println("Integrated Background Area: " + this.decimalFormat.format(chromatogram.getBackgroundIntegratedArea()));
        printWriter.println("Integrated Peak Area: " + this.decimalFormat.format(chromatogram.getPeakIntegratedArea()));
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakListFIDOverview(printWriter, peaks, "Peaks are not available.", monitor);
        printWriter.println("");
        printWriter.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    private void reportPeakListMSDOverview(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printChromatogramPeakListMSDOverview(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void reportPeakListFIDOverview(PrintWriter printWriter, List<IChromatogramPeakCSD> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printChromatogramPeakListFIDOverview(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printChromatogramPeakListMSDOverview(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("RI");
        printWriter.print(DELIMITER);
        printWriter.print("Start RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Stop RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Width (at 50% peak height by inflection points)");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.print(DELIMITER);
        printWriter.print("S/N");
        printWriter.print(DELIMITER);
        printWriter.print("Leading");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Scan #");
        printWriter.print(DELIMITER);
        printWriter.print("Purity");
        printWriter.print(DELIMITER);
        printWriter.print("Integrator");
        printWriter.print(DELIMITER);
        printWriter.print("Detector");
        printWriter.print(DELIMITER);
        printWriter.print("Model");
        printWriter.print(DELIMITER);
        printWriter.print("m/z ...");
        printWriter.println("");
        int counter = 1;
        for (IChromatogramPeakMSD peak : peaks) {
            this.reportPeak(printWriter, peak, counter++, monitor);
        }
    }

    private void printChromatogramPeakListFIDOverview(PrintWriter printWriter, List<IChromatogramPeakCSD> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("RI");
        printWriter.print(DELIMITER);
        printWriter.print("Start RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Stop RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Width (at 50% peak height by inflection points)");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.print(DELIMITER);
        printWriter.print("S/N");
        printWriter.print(DELIMITER);
        printWriter.print("Leading");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Scan #");
        printWriter.print(DELIMITER);
        printWriter.print("Integrator");
        printWriter.print(DELIMITER);
        printWriter.print("Detector");
        printWriter.print(DELIMITER);
        printWriter.print("Model");
        printWriter.println("");
        int counter = 1;
        for (IChromatogramPeakCSD peak : peaks) {
            this.reportPeak(printWriter, peak, counter++, monitor);
        }
    }

    private void reportPeak(PrintWriter printWriter, IChromatogramPeakMSD peak, int number, IProgressMonitor monitor) {
        IPeakModelMSD peakModel = peak.getPeakModel();
        printWriter.print("[" + number + "]");
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getPeakMassSpectrum().getRetentionIndex()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getWidthByInflectionPoints(0.5f) / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getIntegratedArea()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getSignalToNoiseRatio()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getLeading()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(peak.getScanMax());
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getPurity()));
        printWriter.print(DELIMITER);
        printWriter.print(peak.getIntegratorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getDetectorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getModelDescription());
        IPeakMassSpectrum peakMassSpectrum = peakModel.getPeakMassSpectrum();
        List ions = peakMassSpectrum.getIons();
        int numberOfIonsToPrint = ions.size() < 5 ? ions.size() : 5;
        Collections.sort(ions, new IonAbundanceComparator(SortOrder.DESC));
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < numberOfIonsToPrint) {
            IIon ion = (IIon)ions.get(i);
            if (ion.getIon() == 0.0) {
                builder.append("TIC");
            } else {
                builder.append(this.decimalFormat.format(ion.getIon()));
            }
            builder.append(ION_DELIMITER);
            ++i;
        }
        builder.append("...");
        printWriter.print(DELIMITER);
        printWriter.print(builder.toString());
        printWriter.println("");
    }

    private void reportPeak(PrintWriter printWriter, IChromatogramPeakCSD peak, int number, IProgressMonitor monitor) {
        IPeakModelCSD peakModel = peak.getPeakModel();
        printWriter.print("[" + number + "]");
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getPeakMaximum().getRetentionIndex()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getWidthByInflectionPoints(0.5f) / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getIntegratedArea()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getSignalToNoiseRatio()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getLeading()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(peak.getScanMax());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getIntegratorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getDetectorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getModelDescription());
        printWriter.println("");
    }

    private void reportPeakListIntegrationResults(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printPeakIntegrationResults(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printPeakIntegrationResults(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("m/z (0 = TIC or SUM XIC))");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.println("");
        int counter = 1;
        for (IChromatogramPeakMSD peak : peaks) {
            this.reportPeakIntegrationResults(printWriter, peak, counter++, monitor);
        }
    }

    private void reportPeakIntegrationResults(PrintWriter printWriter, IChromatogramPeakMSD peak, int number, IProgressMonitor monitor) {
        List integrationEntries = peak.getIntegrationEntries();
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            if (!(integrationEntry instanceof IIntegrationEntryMSD)) continue;
            IIntegrationEntryMSD integrationEntryMSD = (IIntegrationEntryMSD)integrationEntry;
            printWriter.print("[" + number + "]");
            printWriter.print(DELIMITER);
            double ion = integrationEntryMSD.getIon();
            if (ion == 0.0) {
                printWriter.print("TIC");
            } else {
                printWriter.print(this.decimalFormat.format(ion));
            }
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(integrationEntryMSD.getIntegratedArea()));
            printWriter.println("");
        }
    }

    private void reportPeakListIdentificationResults(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printChromatogramPeaks(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printChromatogramPeaks(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, IProgressMonitor monitor) {
        this.printTargetsHeadline(printWriter, "[#]", monitor);
        int counter = 1;
        for (IChromatogramPeakMSD peak : peaks) {
            List peakTargets = peak.getTargets();
            if (peakTargets.size() > 0) {
                printWriter.println(RESULTS_DELIMITER);
                this.printTargetsData(printWriter, peakTargets, Integer.toString(counter), monitor);
            }
            ++counter;
        }
    }

    private void reportScanIdentificationResults(PrintWriter printWriter, IChromatogramMSD chromatogram, String messageNoResults, IProgressMonitor monitor) {
        if (this.scanTargetsAvailable(chromatogram)) {
            this.printTargetsHeadline(printWriter, "[#]", monitor);
            int i = 1;
            while (i <= chromatogram.getNumberOfScans()) {
                IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(i);
                List massSpectrumTargets = massSpectrum.getTargets();
                if (massSpectrumTargets.size() > 0) {
                    printWriter.println(RESULTS_DELIMITER);
                    this.printTargetsData(printWriter, massSpectrumTargets, Integer.toString(i), monitor);
                }
                ++i;
            }
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private boolean scanTargetsAvailable(IChromatogramMSD chromatogram) {
        boolean scanTargetAvailable = false;
        int i = 1;
        while (i <= chromatogram.getNumberOfScans()) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(i);
            List massSpectrumTargets = massSpectrum.getTargets();
            if (massSpectrumTargets.size() > 0) {
                scanTargetAvailable = true;
                break;
            }
            ++i;
        }
        return scanTargetAvailable;
    }

    private void reportChromatogramIdentificationResults(PrintWriter printWriter, IChromatogramMSD chromatogram, String messageNoResults, IProgressMonitor monitor) {
        List chromatogramTargets = chromatogram.getTargets();
        if (chromatogramTargets.size() > 0) {
            this.printTargetsHeadline(printWriter, null, monitor);
            this.printTargetsData(printWriter, chromatogramTargets, null, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printTargetsHeadline(PrintWriter printWriter, String prefix, IProgressMonitor monitor) {
        if (prefix != null) {
            printWriter.print(prefix);
            printWriter.print(DELIMITER);
        }
        printWriter.print("Name");
        printWriter.print(DELIMITER);
        printWriter.print("CAS");
        printWriter.print(DELIMITER);
        printWriter.print("MatchFactor");
        printWriter.print(DELIMITER);
        printWriter.print("ReverseMatchFactor");
        printWriter.print(DELIMITER);
        printWriter.print("Formula");
        printWriter.print(DELIMITER);
        printWriter.print("Mol Weight");
        printWriter.print(DELIMITER);
        printWriter.print("Probability");
        printWriter.print(DELIMITER);
        printWriter.print("Advise");
        printWriter.print(DELIMITER);
        printWriter.print("Identifier");
        printWriter.print(DELIMITER);
        printWriter.print("Miscellaneous");
        printWriter.print(DELIMITER);
        printWriter.print("Comments");
        printWriter.println("");
    }

    private void printTargetsData(PrintWriter printWriter, List<? extends ITarget> targets, String prefix, IProgressMonitor monitor) {
        for (ITarget iTarget : targets) {
            if (!(iTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = (IIdentificationTarget)iTarget;
            ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
            IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
            if (prefix != null) {
                printWriter.print("[" + prefix + "]");
                printWriter.print(DELIMITER);
            }
            printWriter.print(libraryInformation.getName());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getCasNumber());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getMatchFactor()));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getReverseMatchFactor()));
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getFormula());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(libraryInformation.getMolWeight()));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getProbability()));
            printWriter.print(DELIMITER);
            printWriter.print(comparisonResult.getAdvise());
            printWriter.print(DELIMITER);
            printWriter.print(identificationEntry.getIdentifier());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getMiscellaneous());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getComments());
            printWriter.println("");
        }
    }

    private void reportIntegrationResults(PrintWriter printWriter, List<IIntegrationEntry> integrationEntries, String messageNoResults, IProgressMonitor monitor) {
        if (integrationEntries.size() > 0) {
            this.printIntegrationEntries(printWriter, integrationEntries, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printIntegrationEntries(PrintWriter printWriter, List<IIntegrationEntry> integrationEntries, IProgressMonitor monitor) {
        printWriter.print("m/z (0 = TIC or SUM XIC))");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.println("");
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            if (!(integrationEntry instanceof IIntegrationEntryMSD)) continue;
            IIntegrationEntryMSD integrationEntryMSD = (IIntegrationEntryMSD)integrationEntry;
            double ion = integrationEntryMSD.getIon();
            if (ion == 0.0) {
                printWriter.print("TIC");
            } else {
                printWriter.print(this.decimalFormat.format(ion));
            }
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(integrationEntryMSD.getIntegratedArea()));
            printWriter.println("");
        }
    }

    private void reportPeakListQuantitationResults(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printQuantitationPeaks(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printQuantitationPeaks(PrintWriter printWriter, List<IChromatogramPeakMSD> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("Name");
        printWriter.print(DELIMITER);
        printWriter.print("ChemicalClass");
        printWriter.print(DELIMITER);
        printWriter.print("Concentration");
        printWriter.print(DELIMITER);
        printWriter.print("ConcentrationUnit");
        printWriter.print(DELIMITER);
        printWriter.print("Area");
        printWriter.print(DELIMITER);
        printWriter.print("Description");
        printWriter.print(DELIMITER);
        printWriter.print("Ion");
        printWriter.println("");
        int counter = 1;
        for (IChromatogramPeakMSD peak : peaks) {
            List quantitationEntries = peak.getQuantitationEntries();
            if (quantitationEntries.size() > 0) {
                printWriter.println(RESULTS_DELIMITER);
                this.printPeakQuantitationResults(printWriter, quantitationEntries, counter, monitor);
            }
            ++counter;
        }
    }

    private void printPeakQuantitationResults(PrintWriter printWriter, List<IQuantitationEntry> quantitationEntries, int number, IProgressMonitor monitor) {
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            printWriter.print("[" + number + "]");
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getName());
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getChemicalClass());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(quantitationEntry.getConcentration()));
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getConcentrationUnit());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(quantitationEntry.getArea()));
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getDescription());
            if (quantitationEntry instanceof IQuantitationEntryMSD) {
                IQuantitationEntryMSD quantitationEntryMSD = (IQuantitationEntryMSD)quantitationEntry;
                printWriter.print(DELIMITER);
                double ion = quantitationEntryMSD.getIon();
                if (ion == 0.0) {
                    printWriter.print("TIC");
                } else {
                    printWriter.print(this.decimalFormat.format(ion));
                }
            } else {
                printWriter.print(DELIMITER);
                printWriter.print("--");
            }
            printWriter.println("");
        }
    }
}

