/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.preferences;

import java.io.File;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.app.profiles.Profiles;
import org.eclipse.chemclipse.rcp.app.ui.Activator;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(PreferencePage.class);
    private Label selectedProfileFieldEditor;
    private Combo availableProfilesCombo;
    private Text newProfileNameText;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("");
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("showPerspectiveDialog", "Show the perspective dialog.", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("changePerspectiveAutomatically", "Change perspectives and views automatically.", this.getFieldEditorParent()));
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        Composite composite = new Composite(this.getFieldEditorParent(), 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Selected Profile:");
        this.selectedProfileFieldEditor = new Label(composite, 0);
        this.selectedProfileFieldEditor.setText(this.getPreferenceStore().getString("selectedProfile"));
        this.selectedProfileFieldEditor.setLayoutData((Object)new GridData(768));
        Button deleteProfile = new Button(composite, 0);
        deleteProfile.setText("Delete selected profile");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        deleteProfile.setLayoutData((Object)gridData);
        deleteProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = PreferencePage.this.selectedProfileFieldEditor.getText().trim();
                if (name == null || name.equals("")) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 2);
                    messageBox.setText("Delete profile");
                    messageBox.setMessage("There is no profile selected.");
                    messageBox.open();
                } else {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 456);
                    messageBox.setText("Delete profile?");
                    messageBox.setMessage("Do you really want to delete the profile: " + name);
                    if (messageBox.open() == 64) {
                        Profiles.deleteProfile((String)name);
                        PreferencePage.this.setProfileName("");
                    }
                }
            }
        });
        this.availableProfilesCombo = new Combo(composite, 0);
        this.availableProfilesCombo.setItems(this.getProfileNames());
        this.availableProfilesCombo.setLayoutData((Object)new GridData(768));
        Button loadProfile = new Button(composite, 0);
        loadProfile.setText("Load profile");
        loadProfile.setLayoutData((Object)new GridData(768));
        loadProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = PreferencePage.this.availableProfilesCombo.getText().trim();
                if (name == null || name.equals("")) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 2);
                    messageBox.setText("Load profile");
                    messageBox.setMessage("Please select a profile to load.");
                    messageBox.open();
                } else {
                    try {
                        Profiles.loadProfile((String)name);
                        PreferencePage.this.setProfileName(name);
                        IPreferencePageContainer preferencePageContainer = PreferencePage.this.getContainer();
                        if (preferencePageContainer instanceof PreferenceDialog) {
                            PreferenceDialog preferenceDialog = (PreferenceDialog)preferencePageContainer;
                            preferenceDialog.close();
                            preferenceDialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
                            preferenceDialog.open();
                        }
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                    }
                }
            }
        });
        this.newProfileNameText = new Text(composite, 2048);
        this.newProfileNameText.setLayoutData((Object)new GridData(768));
        Button saveProfile = new Button(composite, 0);
        saveProfile.setText("Save settings as profile");
        saveProfile.setLayoutData((Object)new GridData(768));
        saveProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = PreferencePage.this.newProfileNameText.getText().trim();
                if (name == null || name.equals("")) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 2);
                    messageBox.setText("Save profile");
                    messageBox.setMessage("Please type in a profile name.");
                    messageBox.open();
                } else if (PreferencePage.this.profileExists(name)) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 456);
                    messageBox.setText("Overwrite profile?");
                    messageBox.setMessage("Do you really want to overwrite the profile: " + name);
                    if (messageBox.open() == 64) {
                        PreferencePage.this.createProfile(name);
                    }
                } else {
                    PreferencePage.this.createProfile(name);
                }
            }
        });
    }

    private void setProfileName(String name) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("selectedProfile", name);
        this.selectedProfileFieldEditor.setText(store.getString("selectedProfile"));
        this.availableProfilesCombo.setItems(this.getProfileNames());
        this.newProfileNameText.setText("");
    }

    private String[] getProfileNames() {
        File[] files = Profiles.getAvailableProfiles();
        String[] profileNames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            profileNames[i] = files[i].getName();
            ++i;
        }
        return profileNames;
    }

    private boolean profileExists(String name) {
        String[] profiles;
        String[] stringArray = profiles = this.getProfileNames();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            String profile = stringArray[n2];
            if (profile.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void createProfile(String name) {
        try {
            Profiles.createProfile((String)name, (boolean)true);
            this.setProfileName(name);
        }
        catch (Exception e1) {
            logger.warn((Object)e1);
        }
    }

    public void init(IWorkbench workbench) {
    }
}

