/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.ops.CommonOps;

public class QRColPivDecompositionHouseholderColumn_D64
extends QRDecompositionHouseholderColumn_D64
implements QRPDecomposition<DenseMatrix64F> {
    protected int[] pivots;
    protected double[] normsCol;
    protected double maxAbs;
    protected double singularThreshold = UtilEjml.EPS;
    protected int rank;

    public QRColPivDecompositionHouseholderColumn_D64(double singularThreshold) {
        this.singularThreshold = singularThreshold;
    }

    public QRColPivDecompositionHouseholderColumn_D64() {
    }

    @Override
    public void setSingularThreshold(double threshold) {
        this.singularThreshold = threshold;
    }

    @Override
    public void setExpectedMaxSize(int numRows, int numCols) {
        super.setExpectedMaxSize(numRows, numCols);
        if (this.pivots == null || this.pivots.length < numCols) {
            this.pivots = new int[numCols];
            this.normsCol = new double[numCols];
        }
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F Q, boolean compact) {
        if (compact) {
            if (Q == null) {
                Q = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (Q.numRows != this.numRows || Q.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(Q);
            }
        } else if (Q == null) {
            Q = CommonOps.identity(this.numRows);
        } else {
            if (Q.numRows != this.numRows || Q.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(Q);
        }
        int j = this.rank - 1;
        while (j >= 0) {
            double[] u = this.dataQR[j];
            double vv = u[j];
            u[j] = 1.0;
            QrHelperFunctions_D64.rank1UpdateMultR(Q, u, this.gammas[j], j, j, this.numRows, this.v);
            u[j] = vv;
            --j;
        }
        return Q;
    }

    @Override
    public boolean decompose(DenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        this.convertToColumnMajor(A);
        this.maxAbs = CommonOps.elementMaxAbs(A);
        this.setupPivotInfo();
        int j = 0;
        while (j < this.minLength) {
            if (j > 0) {
                this.updateNorms(j);
            }
            this.swapColumns(j);
            if (!this.householderPivot(j)) break;
            this.updateA(j);
            this.rank = j + 1;
            ++j;
        }
        return true;
    }

    private void setupPivotInfo() {
        int col = 0;
        while (col < this.numCols) {
            this.pivots[col] = col;
            double[] c = this.dataQR[col];
            double norm = 0.0;
            int row = 0;
            while (row < this.numRows) {
                double element = c[row];
                norm += element * element;
                ++row;
            }
            this.normsCol[col] = norm;
            ++col;
        }
    }

    private void updateNorms(int j) {
        boolean foundNegative = false;
        int col = j;
        while (col < this.numCols) {
            double e = this.dataQR[col][j - 1];
            int n = col;
            this.normsCol[n] = this.normsCol[n] - e * e;
            if (this.normsCol[col] < 0.0) {
                foundNegative = true;
                break;
            }
            ++col;
        }
        if (foundNegative) {
            col = j;
            while (col < this.numCols) {
                double[] u = this.dataQR[col];
                double actual = 0.0;
                int i = j;
                while (i < this.numRows) {
                    double v = u[i];
                    actual += v * v;
                    ++i;
                }
                this.normsCol[col] = actual;
                ++col;
            }
        }
    }

    private void swapColumns(int j) {
        int largestIndex = j;
        double largestNorm = this.normsCol[j];
        int col = j + 1;
        while (col < this.numCols) {
            double n = this.normsCol[col];
            if (n > largestNorm) {
                largestNorm = n;
                largestIndex = col;
            }
            ++col;
        }
        double[] tempC = this.dataQR[j];
        this.dataQR[j] = this.dataQR[largestIndex];
        this.dataQR[largestIndex] = tempC;
        double tempN = this.normsCol[j];
        this.normsCol[j] = this.normsCol[largestIndex];
        this.normsCol[largestIndex] = tempN;
        int tempP = this.pivots[j];
        this.pivots[j] = this.pivots[largestIndex];
        this.pivots[largestIndex] = tempP;
    }

    protected boolean householderPivot(int j) {
        double[] u = this.dataQR[j];
        double max = QrHelperFunctions_D64.findMax(u, j, this.numRows - j);
        if (max <= 0.0) {
            return false;
        }
        this.tau = QrHelperFunctions_D64.computeTauAndDivide(j, this.numRows, u, max);
        double u_0 = u[j] + this.tau;
        QrHelperFunctions_D64.divideElements(j + 1, this.numRows, u, u_0);
        this.gamma = u_0 / this.tau;
        this.tau *= max;
        u[j] = -this.tau;
        if (Math.abs(this.tau) <= this.singularThreshold) {
            return false;
        }
        this.gammas[j] = this.gamma;
        return true;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public int[] getPivots() {
        return this.pivots;
    }

    @Override
    public DenseMatrix64F getPivotMatrix(DenseMatrix64F P) {
        if (P == null) {
            P = new DenseMatrix64F(this.numCols, this.numCols);
        } else {
            if (P.numRows != this.numCols) {
                throw new IllegalArgumentException("Number of rows must be " + this.numCols);
            }
            if (P.numCols != this.numCols) {
                throw new IllegalArgumentException("Number of columns must be " + this.numCols);
            }
            P.zero();
        }
        int i = 0;
        while (i < this.numCols) {
            P.set(this.pivots[i], i, 1.0);
            ++i;
        }
        return P;
    }
}

