/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.result;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResult;

public abstract class AbstractChromatogramIntegrationResult
implements IChromatogramIntegrationResult {
    private double chromatogramArea = 0.0;
    private double backgroundArea = 0.0;
    private String integratorType = "";
    private double ion;

    public AbstractChromatogramIntegrationResult(double ion, double chromatogramArea, double backgroundArea) {
        this.ion = ion;
        this.chromatogramArea = chromatogramArea;
        this.backgroundArea = backgroundArea;
    }

    @Override
    public double getBackgroundArea() {
        return this.backgroundArea;
    }

    @Override
    public double getChromatogramArea() {
        return this.chromatogramArea;
    }

    @Override
    public String getIntegratorType() {
        return this.integratorType;
    }

    @Override
    public void setIntegratorType(String integratorType) {
        if (integratorType != null) {
            this.integratorType = integratorType;
        }
    }

    @Override
    public double getIon() {
        return this.ion;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IChromatogramIntegrationResult otherResult = (IChromatogramIntegrationResult)other;
        return this.chromatogramArea == otherResult.getChromatogramArea() && this.backgroundArea == otherResult.getBackgroundArea() && this.integratorType == otherResult.getIntegratorType() && this.ion == otherResult.getIon();
    }

    public int hashCode() {
        return Double.valueOf(this.chromatogramArea).hashCode() + Double.valueOf(this.chromatogramArea).hashCode() + this.integratorType.hashCode() + Double.valueOf(this.ion).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("chromatogramArea=" + this.chromatogramArea);
        builder.append(",");
        builder.append("backgroundArea=" + this.backgroundArea);
        builder.append(",");
        builder.append("integratorType=" + this.integratorType);
        builder.append(",");
        builder.append("ion=" + this.ion);
        builder.append("]");
        return builder.toString();
    }
}

