/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.hideshow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowCommandLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

public class GlazedListsRowHideShowLayer<T>
extends AbstractLayerTransform
implements IRowHideShowCommandLayer,
IUniqueIndexLayer {
    private static final Log log = LogFactory.getLog(GlazedListsRowHideShowLayer.class);
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT = ".hiddenRowIDsCount";
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS = ".hiddenRowIDs";
    private final Set<Serializable> rowIdsToHide = new HashSet<Serializable>();
    private final IRowIdAccessor<T> rowIdAccessor;
    private final IRowDataProvider<T> rowDataProvider;
    private final HideRowMatcherEditor hideRowByIdMatcherEditor = new HideRowMatcherEditor();

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.registerCommandHandlers();
    }

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor, FilterList<T> filterList) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        if (filterList == null) {
            throw new IllegalArgumentException("filterList can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        filterList.setMatcherEditor((MatcherEditor)this.hideRowByIdMatcherEditor);
        this.registerCommandHandlers();
    }

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor, CompositeMatcherEditor<T> matcherEditor) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        if (matcherEditor == null) {
            throw new IllegalArgumentException("matcherEditor can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        matcherEditor.getMatcherEditors().add((Object)this.hideRowByIdMatcherEditor);
        this.registerCommandHandlers();
    }

    protected void registerCommandHandlers() {
        this.registerCommandHandler((ILayerCommandHandler)new RowHideCommandHandler((IRowHideShowCommandLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new MultiRowHideCommandHandler((IRowHideShowCommandLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new ShowAllRowsCommandHandler((IRowHideShowCommandLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new MultiRowShowCommandHandler((IRowHideShowCommandLayer)this));
    }

    public void hideRowPositions(Collection<Integer> rowPositions) {
        HashSet<Serializable> rowIds = new HashSet<Serializable>();
        for (Integer rowPos : rowPositions) {
            int rowIndex = this.getRowIndexByPosition(rowPos);
            rowIds.add(this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex)));
        }
        this.hideRows(rowIds);
    }

    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        HashSet<Serializable> rowIds = new HashSet<Serializable>();
        for (Integer rowIndex : rowIndexes) {
            rowIds.add(this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex.intValue())));
        }
        this.hideRows(rowIds);
    }

    public void showRowIndexes(Collection<Integer> rowIndexes) {
        HashSet<Serializable> rowIds = new HashSet<Serializable>();
        for (Integer rowIndex : rowIndexes) {
            rowIds.add(this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex.intValue())));
        }
        this.showRows(rowIds);
    }

    public void hideRows(Collection<Serializable> rowIds) {
        this.rowIdsToHide.addAll(rowIds);
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public void showRows(Collection<Serializable> rowIds) {
        this.rowIdsToHide.removeAll(rowIds);
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public void showAllRows() {
        this.rowIdsToHide.clear();
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public MatcherEditor<T> getMatcherEditor() {
        return this.hideRowByIdMatcherEditor;
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    public void saveState(String prefix, Properties properties) {
        block16: {
            if (this.rowIdsToHide.size() > 0) {
                properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT, Integer.valueOf(this.rowIdsToHide.size()).toString());
                ObjectOutputStream out = null;
                try {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(bos);
                        for (Serializable serializable : this.rowIdsToHide) {
                            out.writeObject(serializable);
                        }
                        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS, new String(Base64.encodeBase64((byte[])bos.toByteArray())));
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while persisting GlazedListsRowHideShowLayer state", (Throwable)e);
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        super.saveState(prefix, properties);
    }

    public void loadState(String prefix, Properties properties) {
        block16: {
            this.rowIdsToHide.clear();
            String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT);
            int count = property != null ? Integer.valueOf(property) : 0;
            property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS);
            if (property != null) {
                ObjectInputStream in = null;
                try {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])property.getBytes()));
                        in = new ObjectInputStream(bis);
                        Serializable ser = null;
                        int i = 0;
                        while (i < count) {
                            ser = (Serializable)in.readObject();
                            this.rowIdsToHide.add(ser);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while restoring GlazedListsRowHideShowLayer state", (Throwable)e);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.hideRowByIdMatcherEditor.fireChange();
        super.loadState(prefix, properties);
    }

    class HideRowMatcherEditor
    extends AbstractMatcherEditor<T> {
        private final Matcher<T> hideRowByIdMatcher = new Matcher<T>(){

            public boolean matches(T rowObject) {
                return !GlazedListsRowHideShowLayer.this.rowIdsToHide.contains(GlazedListsRowHideShowLayer.this.rowIdAccessor.getRowId(rowObject));
            }
        };

        HideRowMatcherEditor() {
        }

        public void fireChange() {
            this.fireChanged(this.hideRowByIdMatcher);
        }
    }
}

