/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabases;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationCompoundAlreadyExistsException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddAllPeakPage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddAllPeaksWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(AddAllPeaksWizard.class);
    private AddAllPeakPage page;
    private List<IChromatogramPeakMSD> peaks;

    public AddAllPeaksWizard(List<IChromatogramPeakMSD> peaks) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add All Peak to the Quantitation Table");
        this.peaks = peaks;
    }

    public void addPages() {
        this.page = new AddAllPeakPage("Do you like to add the peaks to the quantitation table?\r\nThey will be identified by their best target.\r\nIf a target already exists in the table, it will be merged.");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.removeErrorMessage();
        double concentration = this.page.getConcentration();
        String concentrationUnit = this.page.getConcentrationUnit();
        if (this.peaks == null || this.peaks.size() == 0) {
            this.showErrorMessage("There is no peak list available.");
            return false;
        }
        if (concentrationUnit == null || concentrationUnit.equals("")) {
            this.showErrorMessage("Please select a concentration unit for compounds that will be created.");
            return false;
        }
        if (concentration <= 0.0) {
            this.showErrorMessage("Please select a valid concentration.");
            return false;
        }
        try {
            IQuantDatabase database = QuantDatabases.getQuantDatabase();
            for (IChromatogramPeakMSD peak : this.peaks) {
                String name = this.getPeakTargetName(peak);
                if (name == null) {
                    logger.warn((Object)("The peak has no target. It has been not added to the quantitation table: " + peak));
                    continue;
                }
                if (database.isQuantitationCompoundAlreadyAvailable(name)) {
                    IQuantitationCompoundMSD quantitationCompoundMSD = database.getQuantitationCompound(name);
                    if (quantitationCompoundMSD == null) continue;
                    QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)peak, concentration, quantitationCompoundMSD.getConcentrationUnit());
                    database.getQuantitationPeaks(quantitationCompoundMSD).add(quantitationPeakMSD);
                    continue;
                }
                try {
                    int retentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
                    String chemicalClass = this.page.getChemicalClass();
                    QuantitationCompoundMSD quantitationCompoundMSD = new QuantitationCompoundMSD(name, concentrationUnit, retentionTime);
                    quantitationCompoundMSD.setChemicalClass(chemicalClass);
                    quantitationCompoundMSD.getRetentionTimeWindow().setAllowedNegativeDeviation(1500.0f);
                    quantitationCompoundMSD.getRetentionTimeWindow().setAllowedPositiveDeviation(1500.0f);
                    QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)peak, concentration, concentrationUnit);
                    database.addQuantitationCompound((IQuantitationCompoundMSD)quantitationCompoundMSD);
                    database.getQuantitationPeaks((IQuantitationCompoundMSD)quantitationCompoundMSD).add(quantitationPeakMSD);
                }
                catch (QuantitationCompoundAlreadyExistsException e) {
                    logger.warn((Object)e);
                }
            }
            return true;
        }
        catch (NoQuantitationTableAvailableException e1) {
            logger.warn((Object)e1);
            this.showErrorMessage("Please select a quantitation table previously.");
            return false;
        }
    }

    private String getPeakTargetName(IChromatogramPeakMSD chromatogramPeakMSD) {
        List peakTargets;
        ILibraryInformation libraryInformation = null;
        float bestMatchFactor = 0.0f;
        if (chromatogramPeakMSD != null && (peakTargets = chromatogramPeakMSD.getTargets()).size() > 0) {
            for (IPeakTarget peakTarget : peakTargets) {
                IPeakTarget peakIdentificationEntry;
                float actualMatchFactor;
                if (!(peakTarget instanceof IPeakTarget) || !((actualMatchFactor = (peakIdentificationEntry = peakTarget).getComparisonResult().getMatchFactor()) > bestMatchFactor)) continue;
                bestMatchFactor = actualMatchFactor;
                libraryInformation = peakIdentificationEntry.getLibraryInformation();
            }
        }
        if (libraryInformation == null) {
            return null;
        }
        return libraryInformation.getName();
    }

    private void showErrorMessage(String message) {
        this.page.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.page.setErrorMessage(null);
    }
}

