/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.io;

import org.eclipse.chemclipse.converter.io.AbstractFileHelper;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;

public abstract class AbstractMassSpectraReader
extends AbstractFileHelper
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(AbstractMassSpectraReader.class);

    @Override
    public void extractNameAndReferenceIdentifier(IRegularLibraryMassSpectrum massSpectrum, String value, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        if (value != null) {
            String[] values;
            boolean setNameTraditionally = true;
            if (referenceIdentifierMarker != null && !referenceIdentifierMarker.equals("") && value.contains(referenceIdentifierMarker) && (values = value.split(referenceIdentifierMarker)).length >= 2) {
                setNameTraditionally = false;
                massSpectrum.getLibraryInformation().setName(values[0].trim());
                StringBuilder builder = new StringBuilder();
                if (referenceIdentifierPrefix != null) {
                    builder.append(referenceIdentifierPrefix);
                }
                int size = values.length;
                int i = 1;
                while (i < size) {
                    builder.append(values[i]);
                    if (i < size - 1) {
                        builder.append(" ");
                    }
                    ++i;
                }
                massSpectrum.getLibraryInformation().setReferenceIdentifier(builder.toString().trim());
            }
            if (setNameTraditionally) {
                massSpectrum.getLibraryInformation().setName(value);
            }
        }
    }

    @Override
    public void extractRetentionIndices(IRegularLibraryMassSpectrum massSpectrum, String value, String delimiter) {
        if (value != null && delimiter != null) {
            String[] values;
            boolean setRetentionIndexTraditionally = true;
            if (value.contains(delimiter) && (values = value.split(", ")).length >= 2) {
                setRetentionIndexTraditionally = false;
                float retentionIndex = this.parseFloat(values[0]);
                massSpectrum.setRetentionIndex(retentionIndex);
                massSpectrum.setRetentionIndex(RetentionIndexType.APOLAR, retentionIndex);
                massSpectrum.setRetentionIndex(RetentionIndexType.POLAR, this.parseFloat(values[1]));
            }
            if (setRetentionIndexTraditionally) {
                massSpectrum.setRetentionIndex(this.parseFloat(value));
            }
        }
    }

    private float parseFloat(String value) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(value.trim());
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return result;
    }
}

