/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.peak;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoPeakFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupport;

public class PeakFilterSupport
implements IPeakFilterSupport {
    private List<IPeakFilterSupplier> suppliers = new ArrayList<IPeakFilterSupplier>();

    protected void add(IPeakFilterSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableFilterIds() throws NoPeakFilterSupplierAvailableException {
        this.arePeakFiltersStored();
        ArrayList<String> availableFilters = new ArrayList<String>();
        for (IPeakFilterSupplier supplier : this.suppliers) {
            availableFilters.add(supplier.getId());
        }
        return availableFilters;
    }

    @Override
    public String getFilterId(int index) throws NoPeakFilterSupplierAvailableException {
        this.arePeakFiltersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoPeakFilterSupplierAvailableException("There is no peak filter available with the following id: " + index + ".");
        }
        IPeakFilterSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getFilterNames() throws NoPeakFilterSupplierAvailableException {
        this.arePeakFiltersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IPeakFilterSupplier supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public IPeakFilterSupplier getFilterSupplier(String filterId) throws NoPeakFilterSupplierAvailableException {
        IPeakFilterSupplier filterSupplier = null;
        this.arePeakFiltersStored();
        if (filterId == null || filterId.equals("")) {
            throw new NoPeakFilterSupplierAvailableException("There is no peak filter supplier available with the following id: " + filterId + ".");
        }
        for (IPeakFilterSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(filterId)) continue;
            filterSupplier = supplier;
            break;
        }
        if (filterSupplier == null) {
            throw new NoPeakFilterSupplierAvailableException("There is no peak filter supplier available with the following id: " + filterId + ".");
        }
        return filterSupplier;
    }

    private void arePeakFiltersStored() throws NoPeakFilterSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoPeakFilterSupplierAvailableException();
        }
    }
}

