/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.StandardsReader;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.IRetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.RetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.RetentionIndexTableViewerUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExtendedRetentionIndexTableViewerUI
extends Composite {
    private static final Logger logger = Logger.getLogger(ExtendedRetentionIndexTableViewerUI.class);
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Combo comboReferences;
    private Button buttonAddReference;
    private Text textRetentionTime;
    private Text textRetentionIndex;
    private RetentionIndexTableViewerUI retentionIndexTableViewerUI;
    private List<IRetentionIndexEntry> retentionIndexEntries;
    private List<IRetentionIndexEntry> availableRetentionIndexEntries;

    public ExtendedRetentionIndexTableViewerUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setInput(List<IRetentionIndexEntry> retentionIndexEntries) {
        this.retentionIndexEntries = retentionIndexEntries;
        this.retentionIndexTableViewerUI.setInput(retentionIndexEntries);
    }

    public List<IRetentionIndexEntry> getRetentionIndexEntries() {
        return this.retentionIndexEntries;
    }

    public RetentionIndexTableViewerUI getRetentionIndexTableViewerUI() {
        return this.retentionIndexTableViewerUI;
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.retentionIndexEntries = new ArrayList<IRetentionIndexEntry>();
        StandardsReader standardsReader = new StandardsReader();
        this.availableRetentionIndexEntries = standardsReader.getStandardsList();
        this.createButtonField(composite);
        this.createAddReferenceField(composite);
        this.createTableField(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createButtonField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        label.setLayoutData((Object)gridData);
        Composite compositeButtons = new Composite(composite, 0);
        compositeButtons.setLayout((Layout)new GridLayout(3, true));
        GridData gridDataComposite = new GridData();
        gridDataComposite.horizontalAlignment = 131072;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        this.buttonCancel = new Button(compositeButtons, 8);
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedRetentionIndexTableViewerUI.this.comboReferences.setText("");
                ExtendedRetentionIndexTableViewerUI.this.textRetentionTime.setText("");
                ExtendedRetentionIndexTableViewerUI.this.enableButtonFields(ExtendedRetentionIndexTableViewerUI.ACTION_CANCEL);
            }
        });
        this.buttonDelete = new Button(compositeButtons, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = ExtendedRetentionIndexTableViewerUI.this.retentionIndexTableViewerUI.getTable();
                int index = table.getSelectionIndex();
                if (index >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 8);
                    messageBox.setText("Delete reference(s)?");
                    messageBox.setMessage("Would you like to delete the reference(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        ExtendedRetentionIndexTableViewerUI.this.enableButtonFields(ExtendedRetentionIndexTableViewerUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IRetentionIndexEntry) {
                                IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)object;
                                ExtendedRetentionIndexTableViewerUI.this.retentionIndexEntries.remove(retentionIndexEntry);
                            }
                            ++n2;
                        }
                        ExtendedRetentionIndexTableViewerUI.this.retentionIndexTableViewerUI.setInput(ExtendedRetentionIndexTableViewerUI.this.retentionIndexEntries);
                    }
                }
            }
        });
        this.buttonAdd = new Button(compositeButtons, 8);
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedRetentionIndexTableViewerUI.this.enableButtonFields(ExtendedRetentionIndexTableViewerUI.ACTION_ADD);
            }
        });
    }

    private void createAddReferenceField(Composite composite) {
        this.comboReferences = new Combo(composite, 2048);
        this.comboReferences.setText("");
        this.comboReferences.setItems(this.getAvailableStandards());
        this.comboReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = ExtendedRetentionIndexTableViewerUI.this.comboReferences.getText().trim();
                IRetentionIndexEntry retentionIndexEntry = ExtendedRetentionIndexTableViewerUI.this.getRetentionIndexEntry(name);
                if (retentionIndexEntry != null) {
                    ExtendedRetentionIndexTableViewerUI.this.textRetentionIndex.setText(Float.toString(retentionIndexEntry.getRetentionIndex()));
                } else {
                    ExtendedRetentionIndexTableViewerUI.this.textRetentionIndex.setText("");
                }
            }
        });
        Label labelRetentionTime = new Label(composite, 0);
        labelRetentionTime.setText("RT:");
        this.textRetentionTime = new Text(composite, 2048);
        this.textRetentionTime.setText("");
        this.textRetentionTime.setLayoutData((Object)new GridData(768));
        Label labelRetentionIndex = new Label(composite, 0);
        labelRetentionIndex.setText("RI:");
        this.textRetentionIndex = new Text(composite, 2048);
        this.textRetentionIndex.setText("");
        this.textRetentionIndex.setLayoutData((Object)new GridData(768));
        this.buttonAddReference = new Button(composite, 8);
        this.buttonAddReference.setText("");
        this.buttonAddReference.setImage(ApplicationImageFactory.getInstance().getImage("execute_add.gif", "16x16"));
        this.buttonAddReference.setLayoutData((Object)new GridData(768));
        this.buttonAddReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IRetentionIndexEntry retentionIndexEntry;
                    ExtendedRetentionIndexTableViewerUI.this.enableButtonFields(ExtendedRetentionIndexTableViewerUI.ACTION_INITIALIZE);
                    String name = ExtendedRetentionIndexTableViewerUI.this.comboReferences.getText().trim();
                    int retentionTime = (int)(Double.parseDouble(ExtendedRetentionIndexTableViewerUI.this.textRetentionTime.getText().trim()) * 60000.0);
                    String retentionIndexText = ExtendedRetentionIndexTableViewerUI.this.textRetentionIndex.getText().trim();
                    float retentionIndex = retentionIndexText.equals("") ? ((retentionIndexEntry = ExtendedRetentionIndexTableViewerUI.this.getRetentionIndexEntry(name)) != null ? retentionIndexEntry.getRetentionIndex() : 0.0f) : Float.parseFloat(retentionIndexText);
                    ExtendedRetentionIndexTableViewerUI.this.comboReferences.setText("");
                    ExtendedRetentionIndexTableViewerUI.this.textRetentionTime.setText("");
                    ExtendedRetentionIndexTableViewerUI.this.textRetentionIndex.setText("");
                    retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, name);
                    ExtendedRetentionIndexTableViewerUI.this.retentionIndexEntries.add(retentionIndexEntry);
                    ExtendedRetentionIndexTableViewerUI.this.retentionIndexTableViewerUI.setInput(ExtendedRetentionIndexTableViewerUI.this.retentionIndexEntries);
                }
                catch (Exception e1) {
                    logger.warn((Object)e1);
                }
            }
        });
    }

    private void createTableField(Composite composite) {
        this.retentionIndexTableViewerUI = new RetentionIndexTableViewerUI(composite, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 6;
        this.retentionIndexTableViewerUI.getTable().setLayoutData((Object)gridData);
        this.retentionIndexTableViewerUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedRetentionIndexTableViewerUI.this.enableButtonFields(ExtendedRetentionIndexTableViewerUI.ACTION_SELECT);
            }
        });
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.comboReferences.setEnabled(true);
                this.textRetentionTime.setEnabled(true);
                this.textRetentionIndex.setEnabled(true);
                this.buttonAddReference.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                if (this.retentionIndexTableViewerUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.comboReferences.setEnabled(enabled);
        this.textRetentionTime.setEnabled(enabled);
        this.textRetentionIndex.setEnabled(enabled);
        this.buttonAddReference.setEnabled(enabled);
    }

    private String[] getAvailableStandards() {
        int size = this.availableRetentionIndexEntries.size();
        String[] availableStandards = new String[size];
        int i = 0;
        while (i < size) {
            availableStandards[i] = this.availableRetentionIndexEntries.get(i).getName();
            ++i;
        }
        return availableStandards;
    }

    private IRetentionIndexEntry getRetentionIndexEntry(String name) {
        for (IRetentionIndexEntry retentionIndexEntry : this.availableRetentionIndexEntries) {
            if (!retentionIndexEntry.getName().equals(name)) continue;
            return retentionIndexEntry;
        }
        return null;
    }
}

