/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.BatchProcessJobEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables.BatchProcessRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BatchProcessEditorPage
implements IMultiEditorPage {
    private static final Logger logger = Logger.getLogger(BatchProcessEditorPage.class);
    private FormToolkit toolkit;
    private int pageIndex;

    public BatchProcessEditorPage(BatchProcessJobEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setBatchProcessJob(IBatchProcessJob batchProcessJob) {
    }

    private void createPage(BatchProcessJobEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Batch Process Editor");
        this.createPropertiesSection(scrolledFormComposite, editorPart);
        this.createExecuteSection(editorPart, scrolledFormComposite);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createPropertiesSection(Composite parent, BatchProcessJobEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Info");
        section.setDescription("Please use the report supplier tab to select report formats for the processed chromatograms.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        Label label = this.toolkit.createLabel(client, "");
        label.setLayoutData((Object)gridData);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createExecuteSection(BatchProcessJobEditor editorPart, Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Progress");
        section.setDescription("Run the batch job, after the entries have been edited.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        gridData.heightHint = 30;
        Label label = this.toolkit.createLabel(client, "1. Edit the input,process and output entries.");
        label.setLayoutData((Object)gridData);
        this.createInputFilesPageHyperlink(editorPart, client, gridData);
        this.createProcessEntriesPageHyperlink(editorPart, client, gridData);
        this.createOutputFilesPageHyperlink(editorPart, client, gridData);
        this.createReportEntriesPageHyperlink(editorPart, client, gridData);
        label = this.toolkit.createLabel(client, "2. Run the batch process job after editing the entries.");
        label.setLayoutData((Object)gridData);
        this.createProcessHyperlink(editorPart, client, gridData);
        label = this.toolkit.createLabel(client, "");
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createInputFilesPageHyperlink(final BatchProcessJobEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        imageHyperlink.setText("Configure input files");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("ifp");
            }
        });
    }

    private void createProcessEntriesPageHyperlink(final BatchProcessJobEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        imageHyperlink.setText("Configure process entries");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("pep");
            }
        });
    }

    private void createOutputFilesPageHyperlink(final BatchProcessJobEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        imageHyperlink.setText("Configure output files");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("ofp");
            }
        });
    }

    private void createReportEntriesPageHyperlink(final BatchProcessJobEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        imageHyperlink.setText("Configure report supplier");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                editorPart.setActivePage("rep");
            }
        });
    }

    private void createProcessHyperlink(final BatchProcessJobEditor editorPart, Composite client, GridData gridData) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(client, 64);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        imageHyperlink.setText("Run the batch process");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IPath path;
                String filePath;
                PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.main", (String)"org.eclipse.chemclipse.processing.ui.parts.ProcessingInfoPart");
                Display display = Display.getCurrent();
                if (editorPart.isDirty()) {
                    editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                if ((filePath = (path = ((IFileEditorInput)editorPart.getEditorInput()).getFile().getLocation()).toFile().toString()) != null && !filePath.equals("")) {
                    BatchProcessRunnable runnable = new BatchProcessRunnable(filePath);
                    ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
                    try {
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                        BatchProcessEditorPage.this.refreshWorkspace(path);
                    }
                    catch (InvocationTargetException ex) {
                        logger.warn((Object)ex);
                    }
                    catch (InterruptedException ex) {
                        logger.warn((Object)ex);
                    }
                }
            }
        });
    }

    private void refreshWorkspace(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String workspace = root.getLocation().toFile().toString();
        String file = path.toFile().getParent();
        String containerName = file.replace(workspace, "");
        IResource resource = root.findMember((IPath)new Path("/" + containerName));
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
    }
}

