/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChemClipseEditor;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class SaveAsHandler {
    private static final Logger logger = Logger.getLogger(SaveAsHandler.class);

    @CanExecute
    boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part != null && (part.isDirty() || part.getObject() instanceof IChemClipseEditor);
    }

    @Execute
    void execute(ECommandService commandService, EHandlerService handlerService, EPartService partService, @Named(value="e4ActivePart") MPart part) {
        Object object;
        if (part != null && (object = part.getObject()) != null) {
            if (object instanceof IChemClipseEditor) {
                IChemClipseEditor editor = (IChemClipseEditor)object;
                editor.saveAs();
            } else {
                ParameterizedCommand command = commandService.createCommand("org.eclipse.ui.file.saveAs", null);
                if (handlerService.canExecute(command)) {
                    handlerService.executeHandler(command);
                } else {
                    logger.warn((Object)"Couldn't run the Save As... command.");
                }
            }
        }
    }
}

