/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.peak.detector.support;

import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;

public class RawPeak
implements IRawPeak {
    private int startScan = 0;
    private int maximumScan = 0;
    private int retentionTimeMaximum = 0;
    private int stopScan = 0;

    public RawPeak(int startScan, int maximumScan, int stopScan) {
        if (startScan < maximumScan && maximumScan < stopScan) {
            this.startScan = startScan;
            this.maximumScan = maximumScan;
            this.stopScan = stopScan;
        }
    }

    @Override
    public int getMaximumScan() {
        return this.maximumScan;
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public int getRetentionTimeAtMaximum() {
        return this.retentionTimeMaximum;
    }

    @Override
    public void setRetentionTimeAtMaximum(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTimeMaximum = retentionTime;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RawPeak otherRawPeak = (RawPeak)other;
        return this.getStartScan() == otherRawPeak.getStartScan() && this.getMaximumScan() == otherRawPeak.getMaximumScan() && this.getStopScan() == otherRawPeak.getStopScan();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.startScan).hashCode() + 11 * Integer.valueOf(this.maximumScan).hashCode() + 13 * Integer.valueOf(this.stopScan).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startScan=" + this.startScan);
        builder.append(",");
        builder.append("maximumScan=" + this.maximumScan);
        builder.append(",");
        builder.append("stopScan=" + this.stopScan);
        builder.append("]");
        return builder.toString();
    }
}

