/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io.EventFilterScan;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorScan;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractReaderVersion
extends AbstractChromatogramMSDReader
implements IChromatogramMSDReader {
    private static final Logger logger = Logger.getLogger(AbstractReaderVersion.class);

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream);
            EventFilterScan eventFilter = new EventFilterScan();
            XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
            chromatogram = new VendorChromatogram();
            while (filteredEventReader.hasNext()) {
                int retentionTime = 0;
                float totalSignal = 0.0f;
                XMLEvent xmlEvent = filteredEventReader.nextEvent();
                Iterator<Attribute> attributes = xmlEvent.asStartElement().getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String attributeName = attribute.getName().getLocalPart();
                    if (attributeName.equals("retentionTime")) {
                        try {
                            Duration duration = DatatypeFactory.newInstance().newDuration(attribute.getValue());
                            retentionTime = duration.multiply(1000).getSeconds();
                        }
                        catch (DatatypeConfigurationException e) {
                            logger.warn((Object)e);
                        }
                        continue;
                    }
                    if (!attributeName.equals("totIonCurrent")) continue;
                    totalSignal = Float.valueOf(attribute.getValue()).floatValue();
                }
                VendorScan massSpectrum = new VendorScan();
                massSpectrum.setRetentionTime(retentionTime);
                try {
                    massSpectrum.addIon((IIon)new VendorIon(0.0, totalSignal));
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
                chromatogram.addScan((IScan)massSpectrum);
            }
        }
        catch (XMLStreamException e) {
            logger.warn((Object)e);
        }
        return chromatogram;
    }
}

