/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.statistics;

import java.util.Arrays;
import java.util.List;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class Calculations {
    public static int getSum(int[] values) {
        int sum = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            sum += value;
            ++n2;
        }
        return sum;
    }

    public static float getSum(float[] values) {
        float sum = 0.0f;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sum += value;
            ++n2;
        }
        return sum;
    }

    public static double getSum(double[] values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        return sum;
    }

    public static double getEuclidianLength(double[] values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += Math.pow(value, 2.0);
            ++n2;
        }
        return Math.sqrt(sum);
    }

    public static double getMin(double[] values) {
        if (values.length == 0) {
            return 0.0;
        }
        double minValue = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < minValue) {
                minValue = values[i];
            }
            ++i;
        }
        return minValue;
    }

    public static double getMax(double[] values) {
        if (values.length == 0) {
            return 0.0;
        }
        double[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        return val[val.length - 1];
    }

    public static float getMin(float[] values) {
        if (values.length == 0) {
            return 0.0f;
        }
        float[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        return val[0];
    }

    public static float getMax(float[] values) {
        if (values.length == 0) {
            return 0.0f;
        }
        float[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        return val[val.length - 1];
    }

    public static double getMean(double[] values) {
        double sum = 0.0;
        int size = Calculations.getSize(values);
        if (size == 0) {
            return 0.0;
        }
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        return sum / (double)size;
    }

    public static float getMean(float[] values) {
        float sum = 0.0f;
        int size = Calculations.getSize(values);
        if (size == 0) {
            return 0.0f;
        }
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sum += value;
            ++n2;
        }
        return sum / (float)size;
    }

    public static int getMean(int[] values) {
        int sum = 0;
        int size = Calculations.getSize(values);
        if (size == 0) {
            return 0;
        }
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            sum += value;
            ++n2;
        }
        return sum / size;
    }

    public static double getMedian(List<Double> values) {
        double median = 0.0;
        if (values != null) {
            double[] data = new double[values.size()];
            int i = 0;
            while (i < values.size()) {
                if (values.get(i) != null) {
                    data[i] = values.get(i);
                }
                ++i;
            }
            median = Calculations.getMedian(data);
        }
        return median;
    }

    public static double getMedian(double[] values) {
        double mean = 0.0;
        int size = Calculations.getSize(values);
        if (size < 3) {
            return 0.0;
        }
        double[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        if (Calculations.isOdd(size)) {
            int n1 = size / 2;
            mean = val[n1];
        } else {
            int n1 = (size - 1) / 2;
            int n2 = size / 2;
            mean = 0.5 * (val[n1] + val[n2]);
        }
        return mean;
    }

    public static float getMedian(float[] values) {
        float mean = 0.0f;
        int size = Calculations.getSize(values);
        if (size < 3) {
            return 0.0f;
        }
        float[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        if (Calculations.isOdd(size)) {
            int n1 = size / 2;
            mean = val[n1];
        } else {
            int n1 = (size - 1) / 2;
            int n2 = size / 2;
            mean = 0.5f * (val[n1] + val[n2]);
        }
        return mean;
    }

    public static int getMedian(int[] values) {
        int mean = 0;
        int size = Calculations.getSize(values);
        if (size < 3) {
            return 0;
        }
        int[] val = Arrays.copyOf(values, values.length);
        Arrays.sort(val);
        if (Calculations.isOdd(size)) {
            int n1 = size / 2;
            mean = val[n1];
        } else {
            int n1 = (size - 1) / 2;
            int n2 = size / 2;
            mean = (int)(0.5f * (float)(val[n1] + val[n2]));
        }
        return mean;
    }

    public static double getMedianDeviationFromMean(double[] values) {
        int size = Calculations.getSize(values);
        if (size < 3) {
            return 0.0;
        }
        double[] deviationFromMean = new double[values.length];
        double mean = Calculations.getMean(values);
        int i = 0;
        while (i < values.length) {
            deviationFromMean[i] = Math.sqrt(Math.pow(values[i] - mean, 2.0));
            ++i;
        }
        return Calculations.getMedian(deviationFromMean);
    }

    public static double getMedianDeviationFromMedian(double[] values) {
        int size = Calculations.getSize(values);
        if (size < 3) {
            return 0.0;
        }
        double[] deviationFromMedian = new double[values.length];
        double median = Calculations.getMedian(values);
        int i = 0;
        while (i < values.length) {
            deviationFromMedian[i] = Math.sqrt(Math.pow(values[i] - median, 2.0));
            ++i;
        }
        return Calculations.getMedian(deviationFromMedian);
    }

    public static double getVariance(double[] values) {
        double mean = Calculations.getMean(values);
        return Calculations.getVariance(values, mean);
    }

    public static float getVariance(float[] values) {
        float mean = Calculations.getMean(values);
        return Calculations.getVariance(values, mean);
    }

    public static double getVariance(double[] values, double mean) {
        double sum = 0.0;
        int size = Calculations.getSize(values);
        if (size < 2) {
            return 0.0;
        }
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += Math.pow(value - mean, 2.0);
            ++n2;
        }
        return 1.0 / (double)(size - 1) * sum;
    }

    public static float getVariance(float[] values, float mean) {
        float sum = 0.0f;
        int size = Calculations.getSize(values);
        if (size < 2) {
            return 0.0f;
        }
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sum += (float)Math.pow(value - mean, 2.0);
            ++n2;
        }
        return 1.0f / (float)(size - 1) / sum;
    }

    public static double getStandardDeviation(double medianFromMean) {
        return Math.sqrt(medianFromMean);
    }

    public static float getStandardDeviation(float medianFromMean) {
        return (float)Math.sqrt(medianFromMean);
    }

    public static double getStandardDeviation(double[] values) {
        double variance = Calculations.getVariance(values);
        return Math.sqrt(variance);
    }

    public static float getStandardDeviation(float[] values) {
        float median = Calculations.getVariance(values);
        return (float)Math.sqrt(median);
    }

    public static double getStandardDeviation(double[] values, double mean) {
        double median = Calculations.getVariance(values, mean);
        return Math.sqrt(median);
    }

    public static float getStandardDeviation(float[] values, float mean) {
        float median = Calculations.getVariance(values, mean);
        return (float)Math.sqrt(median);
    }

    public static void normalize(float[] values) {
        float max = Calculations.getMax(values);
        if (max > 0.0f) {
            int i = 0;
            while (i < values.length) {
                int n = i++;
                values[n] = values[n] / max;
            }
        }
    }

    public static void normalize(double[] values) {
        double max = Calculations.getMax(values);
        if (max > 0.0) {
            int i = 0;
            while (i < values.length) {
                int n = i++;
                values[n] = values[n] / max;
            }
        }
    }

    public static void smooth(double[] values, WindowSize windowSize) {
        int window = 1;
        if (windowSize != null && windowSize.getSize() > 0 && windowSize.getSize() <= values.length) {
            window = windowSize.getSize();
        }
        int lastScan = Calculations.getWindowReducedLength(values, window);
        int i = 0;
        while (i < lastScan) {
            double sumSignals = 0.0;
            int j = 0;
            while (j < window) {
                sumSignals += values[j + i];
                ++j;
            }
            values[i] = 1.0 / (double)window * sumSignals;
            ++i;
        }
    }

    public static int getWindowReducedLength(double[] values, int window) {
        if (values == null) {
            return 0;
        }
        if (window < 1 || window > values.length) {
            window = 1;
        }
        return values.length - window + 1;
    }

    public static void scaleToEuclidianLength(double[] values) {
        double euclidianLength = Calculations.getEuclidianLength(values);
        int i = 0;
        while (i < values.length) {
            values[i] = values[i] / euclidianLength;
            ++i;
        }
    }

    public static void scaleToStandardizedLength(double[] values) {
        double mean = Calculations.getMean(values);
        double standardDeviation = Calculations.getStandardDeviation(values, mean);
        int i = 0;
        while (i < values.length) {
            values[i] = (values[i] - mean) / standardDeviation;
            ++i;
        }
    }

    public static void scaleToNormalizedUnity(double[] values) {
        double powTwoSum = Calculations.calculateSumPow2(values);
        if (powTwoSum == 0.0) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            double adjustedValue;
            values[i] = adjustedValue = Math.pow(values[i], 2.0) / powTwoSum;
            ++i;
        }
    }

    public static double calculateSumPow2(double[] values) {
        double powTwoSum = 0.0;
        int i = 0;
        while (i < values.length) {
            powTwoSum += Math.pow(values[i], 2.0);
            ++i;
        }
        return powTwoSum;
    }

    private static int getSize(double[] values) {
        if (values == null) {
            return 0;
        }
        return values.length;
    }

    private static int getSize(float[] values) {
        if (values == null) {
            return 0;
        }
        return values.length;
    }

    private static int getSize(int[] values) {
        if (values == null) {
            return 0;
        }
        return values.length;
    }

    private static boolean isOdd(int size) {
        return size % 2 != 0;
    }
}

