/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GUIHelper {
    private static final String KEY_PREFIX = String.valueOf(GUIHelper.class.getCanonicalName()) + ".";
    public static final Color COLOR_GRAY = Display.getDefault().getSystemColor(15);
    public static final Color COLOR_WHITE = Display.getDefault().getSystemColor(1);
    public static final Color COLOR_DARK_GRAY = Display.getDefault().getSystemColor(16);
    public static final Color COLOR_BLACK = Display.getDefault().getSystemColor(2);
    public static final Color COLOR_BLUE = Display.getDefault().getSystemColor(9);
    public static final Color COLOR_RED = Display.getDefault().getSystemColor(3);
    public static final Color COLOR_YELLOW = Display.getDefault().getSystemColor(7);
    public static final Color COLOR_GREEN = Display.getDefault().getSystemColor(5);
    public static final Color COLOR_LIST_BACKGROUND = Display.getDefault().getSystemColor(25);
    public static final Color COLOR_LIST_FOREGROUND = Display.getDefault().getSystemColor(24);
    public static final Color COLOR_LIST_SELECTION = Display.getDefault().getSystemColor(26);
    public static final Color COLOR_LIST_SELECTION_TEXT = Display.getDefault().getSystemColor(27);
    public static final Color COLOR_WIDGET_BACKGROUND = Display.getDefault().getSystemColor(22);
    public static final Color COLOR_WIDGET_FOREGROUND = Display.getDefault().getSystemColor(21);
    public static final Color COLOR_TITLE_INACTIVE_BACKGROUND = Display.getDefault().getSystemColor(34);
    public static final Color COLOR_WIDGET_BORDER = Display.getDefault().getSystemColor(23);
    public static final Color COLOR_WIDGET_DARK_SHADOW = Display.getDefault().getSystemColor(17);
    public static final Color COLOR_WIDGET_LIGHT_SHADOW = Display.getDefault().getSystemColor(19);
    public static final Color COLOR_WIDGET_NORMAL_SHADOW = Display.getDefault().getSystemColor(18);
    public static final Color COLOR_WIDGET_HIGHLIGHT_SHADOW = Display.getDefault().getSystemColor(20);
    public static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    public static final int DEFAULT_RESIZE_HANDLE_SIZE = 4;
    public static final int DEFAULT_MIN_DISPLAY_SIZE = 5;
    public static final int DEFAULT_ANTIALIAS = -1;
    public static final int DEFAULT_TEXT_ANTIALIAS = -1;
    private static final String[] IMAGE_DIRS = new String[]{"org/eclipse/nebula/widgets/nattable/images/", ""};
    private static final String[] IMAGE_EXTENSIONS = new String[]{".png", ".gif"};
    private static final AtomicLong atomicLong = new AtomicLong(0L);
    private static float[] dpiFactor = new float[]{1.0f, 1.25f, 1.33f, 1.5f, 2.0f, 3.0f};

    public static Color getColor(RGB rgb) {
        return GUIHelper.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        String key = GUIHelper.getColorKey(red, green, blue);
        if (JFaceResources.getColorRegistry().hasValueFor(key)) {
            return JFaceResources.getColorRegistry().get(key);
        }
        JFaceResources.getColorRegistry().put(key, new RGB(red, green, blue));
        return GUIHelper.getColor(key);
    }

    public static Color getColor(String key) {
        return JFaceResources.getColorRegistry().get(key);
    }

    private static String getColorKey(int red, int green, int blue) {
        return String.valueOf(KEY_PREFIX) + "_COLOR_" + red + "_" + green + "_" + blue;
    }

    public static Font getFont(FontData ... fontDatas) {
        StringBuilder keyBuilder = new StringBuilder();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            keyBuilder.append(fontData.toString());
            ++n2;
        }
        String key = keyBuilder.toString();
        if (JFaceResources.getFontRegistry().hasValueFor(key)) {
            return JFaceResources.getFont((String)key);
        }
        JFaceResources.getFontRegistry().put(key, fontDatas);
        return JFaceResources.getFont((String)key);
    }

    public static Font getFont(String key) {
        return JFaceResources.getFont((String)key);
    }

    public static Image getImageByURL(URL url) {
        String basename = url.toString();
        basename = basename.substring(basename.lastIndexOf(47) + 1, basename.lastIndexOf(46));
        return GUIHelper.getImageByURL(basename, url);
    }

    public static Image getImageByURL(String key, URL url) {
        Image image = JFaceResources.getImage((String)key);
        if (image == null) {
            if (GUIHelper.needScaling()) {
                String urlString = url.toString();
                int extIndex = urlString.lastIndexOf(46);
                String ext = urlString.substring(extIndex, urlString.length());
                String base = urlString.substring(0, extIndex);
                try {
                    URL scaleURL = new URL(String.valueOf(base) + GUIHelper.getScalingImageSuffix() + ext);
                    URLConnection con = scaleURL.openConnection();
                    con.connect();
                    JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)scaleURL));
                }
                catch (IOException iOException) {
                    ImageData imageData = ImageDescriptor.createFromURL((URL)url).getImageData();
                    imageData = imageData.scaledTo(GUIHelper.convertHorizontalPixelToDpi(imageData.width), GUIHelper.convertVerticalPixelToDpi(imageData.height));
                    JFaceResources.getImageRegistry().put(key, new Image((Device)Display.getDefault(), imageData));
                }
            } else {
                JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)url));
            }
            image = JFaceResources.getImage((String)key);
        }
        return image;
    }

    public static Image getImage(String imageName) {
        URL imageUrl;
        Image image = JFaceResources.getImage((String)imageName);
        if (image == null && (imageUrl = GUIHelper.getInternalImageUrl(imageName)) != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
            if (GUIHelper.needScaling() && !imageUrl.getFile().contains(GUIHelper.getScalingImageSuffix())) {
                ImageData imageData = imageDescriptor.getImageData();
                imageData = imageData.scaledTo(GUIHelper.convertHorizontalPixelToDpi(imageData.width), GUIHelper.convertVerticalPixelToDpi(imageData.height));
                JFaceResources.getImageRegistry().put(imageName, new Image((Device)Display.getDefault(), imageData));
            } else {
                JFaceResources.getImageRegistry().put(imageName, imageDescriptor.createImage());
            }
            image = JFaceResources.getImage((String)imageName);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String imageName) {
        ImageDescriptor imageDescriptor = null;
        URL imageUrl = GUIHelper.getInternalImageUrl(imageName);
        if (imageUrl != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
        }
        return imageDescriptor;
    }

    private static URL getInternalImageUrl(String imageName) {
        String[] stringArray = IMAGE_DIRS;
        int n = IMAGE_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = IMAGE_EXTENSIONS;
            int n3 = IMAGE_EXTENSIONS.length;
            int n4 = 0;
            while (n4 < n3) {
                String ext = stringArray2[n4];
                URL url = null;
                if (GUIHelper.needScaling()) {
                    url = GUIHelper.class.getClassLoader().getResource(String.valueOf(dir) + imageName + GUIHelper.getScalingImageSuffix() + ext);
                }
                if (url == null) {
                    url = GUIHelper.class.getClassLoader().getResource(String.valueOf(dir) + imageName + ext);
                }
                if (url != null) {
                    return url;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static Image getImage(ImageData data) {
        if (JFaceResources.getImage((String)data.toString()) == null) {
            JFaceResources.getImageRegistry().put(data.toString(), ImageDescriptor.createFromImageData((ImageData)data));
        }
        return JFaceResources.getImage((String)data.toString());
    }

    public static String getSequenceNumber() {
        long id = atomicLong.addAndGet(1L);
        return String.valueOf(id);
    }

    public static RGB blend(RGB val1, RGB val2) {
        int red = GUIHelper.blend(val1.red, val2.red);
        int green = GUIHelper.blend(val1.green, val2.green);
        int blue = GUIHelper.blend(val1.blue, val2.blue);
        return new RGB(red, green, blue);
    }

    private static int blend(int temp1, int temp2) {
        return Math.abs(temp1 - temp2) / 2 + Math.min(temp1, temp2);
    }

    public static float getDpiFactor(int dpi) {
        float factor = 1.0f;
        switch (dpi) {
            case 96: {
                factor = dpiFactor[0];
                break;
            }
            case 120: {
                factor = dpiFactor[1];
                break;
            }
            case 128: {
                factor = dpiFactor[2];
                break;
            }
            case 144: {
                factor = dpiFactor[3];
                break;
            }
            case 192: {
                factor = dpiFactor[4];
                break;
            }
            case 288: {
                factor = dpiFactor[5];
            }
        }
        return factor;
    }

    public static boolean needScaling() {
        return GUIHelper.getDpiX() > 96 || GUIHelper.getDpiY() > 96;
    }

    public static int getDpiX() {
        return Display.getDefault().getDPI().x;
    }

    public static int getDpiY() {
        return Display.getDefault().getDPI().y;
    }

    public static String getScalingImageSuffix() {
        return "_" + GUIHelper.getDpiX() + "_" + GUIHelper.getDpiY();
    }

    public static int convertHorizontalPixelToDpi(int pixel) {
        return Float.valueOf((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiX())).intValue();
    }

    public static int convertHorizontalDpiToPixel(int dpi) {
        return Float.valueOf((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiY())).intValue();
    }

    public static int convertVerticalPixelToDpi(int pixel) {
        return Float.valueOf((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiX())).intValue();
    }

    public static int convertVerticalDpiToPixel(int dpi) {
        return Float.valueOf((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiY())).intValue();
    }
}

