/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

public abstract class AbstractDpiConverter
implements IDpiConverter {
    protected Integer dpi;

    protected abstract void readDpiFromDisplay();

    @Override
    public int getDpi() {
        if (this.dpi == null) {
            this.readDpiFromDisplay();
        }
        return this.dpi;
    }

    @Override
    public float getCurrentDpiFactor() {
        return GUIHelper.getDpiFactor(this.getDpi());
    }

    @Override
    public int convertPixelToDpi(int pixel) {
        return Float.valueOf((float)pixel * this.getCurrentDpiFactor()).intValue();
    }

    @Override
    public int convertDpiToPixel(int dpi) {
        return Float.valueOf((float)dpi / this.getCurrentDpiFactor()).intValue();
    }
}

