/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

@Deprecated
public class MultivariateFunctionPenaltyAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final double[] lower;
    private final double[] upper;
    private final double offset;
    private final double[] scale;

    public MultivariateFunctionPenaltyAdapter(MultivariateFunction bounded, double[] lower, double[] upper, double offset, double[] scale) {
        MathUtils.checkNotNull(lower);
        MathUtils.checkNotNull(upper);
        MathUtils.checkNotNull(scale);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        if (lower.length != scale.length) {
            throw new DimensionMismatchException(lower.length, scale.length);
        }
        int i = 0;
        while (i < lower.length) {
            if (!(upper[i] >= lower[i])) {
                throw new NumberIsTooSmallException(upper[i], (Number)lower[i], true);
            }
            ++i;
        }
        this.bounded = bounded;
        this.lower = (double[])lower.clone();
        this.upper = (double[])upper.clone();
        this.offset = offset;
        this.scale = (double[])scale.clone();
    }

    @Override
    public double value(double[] point) {
        int i = 0;
        while (i < this.scale.length) {
            if (point[i] < this.lower[i] || point[i] > this.upper[i]) {
                double sum = 0.0;
                int j = i;
                while (j < this.scale.length) {
                    double overshoot = point[j] < this.lower[j] ? this.scale[j] * (this.lower[j] - point[j]) : (point[j] > this.upper[j] ? this.scale[j] * (point[j] - this.upper[j]) : 0.0);
                    sum += FastMath.sqrt(overshoot);
                    ++j;
                }
                return this.offset + sum;
            }
            ++i;
        }
        return this.bounded.value(point);
    }
}

