/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.linear;

import java.util.ArrayList;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearOptimizer;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.PivotSelectionRule;
import org.apache.commons.math3.optim.linear.SimplexTableau;
import org.apache.commons.math3.optim.linear.SolutionCallback;
import org.apache.commons.math3.optim.linear.UnboundedSolutionException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class SimplexSolver
extends LinearOptimizer {
    static final int DEFAULT_ULPS = 10;
    static final double DEFAULT_CUT_OFF = 1.0E-10;
    private static final double DEFAULT_EPSILON = 1.0E-6;
    private final double epsilon;
    private final int maxUlps;
    private final double cutOff;
    private PivotSelectionRule pivotSelection;
    private SolutionCallback solutionCallback;

    public SimplexSolver() {
        this(1.0E-6, 10, 1.0E-10);
    }

    public SimplexSolver(double epsilon) {
        this(epsilon, 10, 1.0E-10);
    }

    public SimplexSolver(double epsilon, int maxUlps) {
        this(epsilon, maxUlps, 1.0E-10);
    }

    public SimplexSolver(double epsilon, int maxUlps, double cutOff) {
        this.epsilon = epsilon;
        this.maxUlps = maxUlps;
        this.cutOff = cutOff;
        this.pivotSelection = PivotSelectionRule.DANTZIG;
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyIterationsException {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        this.solutionCallback = null;
        OptimizationData[] optimizationDataArray = optData;
        int n = optData.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizationData data = optimizationDataArray[n2];
            if (data instanceof SolutionCallback) {
                this.solutionCallback = (SolutionCallback)data;
            } else if (data instanceof PivotSelectionRule) {
                this.pivotSelection = (PivotSelectionRule)data;
            }
            ++n2;
        }
    }

    private Integer getPivotColumn(SimplexTableau tableau) {
        double minValue = 0.0;
        Integer minPos = null;
        int i = tableau.getNumObjectiveFunctions();
        while (i < tableau.getWidth() - 1) {
            double entry = tableau.getEntry(0, i);
            if (entry < minValue) {
                minValue = entry;
                minPos = i;
                if (this.pivotSelection == PivotSelectionRule.BLAND && this.isValidPivotColumn(tableau, i)) break;
            }
            ++i;
        }
        return minPos;
    }

    private boolean isValidPivotColumn(SimplexTableau tableau, int col) {
        int i = tableau.getNumObjectiveFunctions();
        while (i < tableau.getHeight()) {
            double entry = tableau.getEntry(i, col);
            if (Precision.compareTo(entry, 0.0, this.cutOff) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Integer getPivotRow(SimplexTableau tableau, int col) {
        ArrayList<Integer> minRatioPositions = new ArrayList<Integer>();
        double minRatio = Double.MAX_VALUE;
        int i = tableau.getNumObjectiveFunctions();
        while (i < tableau.getHeight()) {
            double rhs = tableau.getEntry(i, tableau.getWidth() - 1);
            double entry = tableau.getEntry(i, col);
            if (Precision.compareTo(entry, 0.0, this.cutOff) > 0) {
                double ratio = FastMath.abs(rhs / entry);
                int cmp = Double.compare(ratio, minRatio);
                if (cmp == 0) {
                    minRatioPositions.add(i);
                } else if (cmp < 0) {
                    minRatio = ratio;
                    minRatioPositions.clear();
                    minRatioPositions.add(i);
                }
            }
            ++i;
        }
        if (minRatioPositions.size() == 0) {
            return null;
        }
        if (minRatioPositions.size() > 1) {
            if (tableau.getNumArtificialVariables() > 0) {
                for (Integer row : minRatioPositions) {
                    int i2 = 0;
                    while (i2 < tableau.getNumArtificialVariables()) {
                        int column = i2 + tableau.getArtificialVariableOffset();
                        double entry = tableau.getEntry(row, column);
                        if (Precision.equals(entry, 1.0, this.maxUlps) && row.equals(tableau.getBasicRow(column))) {
                            return row;
                        }
                        ++i2;
                    }
                }
            }
            Integer minRow = null;
            int minIndex = tableau.getWidth();
            for (Integer row : minRatioPositions) {
                int basicVar = tableau.getBasicVariable(row);
                if (basicVar >= minIndex) continue;
                minIndex = basicVar;
                minRow = row;
            }
            return minRow;
        }
        return (Integer)minRatioPositions.get(0);
    }

    protected void doIteration(SimplexTableau tableau) throws TooManyIterationsException, UnboundedSolutionException {
        this.incrementIterationCount();
        Integer pivotCol = this.getPivotColumn(tableau);
        Integer pivotRow = this.getPivotRow(tableau, pivotCol);
        if (pivotRow == null) {
            throw new UnboundedSolutionException();
        }
        tableau.performRowOperations(pivotCol, pivotRow);
    }

    /*
     * Unable to fully structure code
     */
    protected void solvePhase1(SimplexTableau tableau) throws TooManyIterationsException, UnboundedSolutionException, NoFeasibleSolutionException {
        if (tableau.getNumArtificialVariables() != 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.doIteration(tableau);
lbl4:
            // 2 sources

            ** while (!tableau.isOptimal())
        }
lbl5:
        // 1 sources

        if (!Precision.equals(tableau.getEntry(0, tableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    @Override
    public PointValuePair doOptimize() throws TooManyIterationsException, UnboundedSolutionException, NoFeasibleSolutionException {
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau(null);
        }
        SimplexTableau tableau = new SimplexTableau(this.getFunction(), this.getConstraints(), this.getGoalType(), this.isRestrictedToNonNegative(), this.epsilon, this.maxUlps);
        this.solvePhase1(tableau);
        tableau.dropPhase1Objective();
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau(tableau);
        }
        while (!tableau.isOptimal()) {
            this.doIteration(tableau);
        }
        PointValuePair solution = tableau.getSolution();
        if (this.isRestrictedToNonNegative()) {
            double[] coeff = solution.getPoint();
            int i = 0;
            while (i < coeff.length) {
                if (Precision.compareTo(coeff[i], 0.0, this.epsilon) < 0) {
                    throw new NoFeasibleSolutionException();
                }
                ++i;
            }
        }
        return solution;
    }
}

