/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.connector.supplier.microsoft.office.ui.editors;

import java.io.File;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.EditorPart;

public abstract class OLEEditor
extends EditorPart {
    private FormToolkit formToolkit;
    private OleControlSite oleControlSite;
    private File officeFile;
    private String progId;
    private String filterExtension;
    private String filterName;
    private boolean isDirty = false;

    public OLEEditor(String progId, String filterExtension, String filterName) {
        this.progId = progId;
        this.filterExtension = filterExtension;
        this.filterName = filterName;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isOleEditorActive()) {
            this.oleControlSite.save(this.officeFile, true);
            this.isDirty = false;
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
        if (this.isOleEditorActive()) {
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setFilterExtensions(new String[]{this.filterExtension});
            fileDialog.setFilterNames(new String[]{this.filterName});
            String filePath = fileDialog.open();
            if (filePath != null) {
                File officeFileNew = new File(filePath);
                if (this.isOleEditorActive()) {
                    this.oleControlSite.save(officeFileNew, true);
                }
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (input instanceof IPathEditorInput) {
            this.officeFile = ((IPathEditorInput)input).getPath().toFile();
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        if (OperatingSystemUtils.isWindows()) {
            Composite oleComposite = new Composite(parent, 0);
            oleComposite.setLayout((Layout)new FillLayout());
            OleFrame oleFrame = new OleFrame(oleComposite, 0);
            try {
                this.oleControlSite = new OleControlSite((Composite)oleFrame, 0, this.progId, this.officeFile);
                this.registerOfficeDocumentChangeListener(this.oleControlSite);
            }
            catch (Exception exception) {
                this.oleControlSite = null;
                oleFrame.dispose();
                this.createInfo(oleComposite);
            }
        } else {
            this.createInfo(parent);
        }
    }

    private void registerOfficeDocumentChangeListener(OleControlSite controlSite) {
        OleAutomation oleAutomationDocument = new OleAutomation((OleClientSite)controlSite);
        int[] dispIDs = oleAutomationDocument.getIDsOfNames(new String[]{"Application"});
        Variant variant = oleAutomationDocument.getProperty(dispIDs[0]);
        OleAutomation oleAutomationApplication = variant.getAutomation();
        variant.dispose();
        oleAutomationDocument.dispose();
        OleListener listener = new OleListener(){

            public void handleEvent(OleEvent e) {
                OLEEditor.this.setDirty();
            }
        };
        if (this.progId.equals("Excel.Sheet")) {
            controlSite.addEventListener(oleAutomationApplication, "{00024413-0000-0000-C000-000000000046}", 1565, listener);
            controlSite.addEventListener(oleAutomationApplication, "{00024413-0000-0000-C000-000000000046}", 1561, listener);
            controlSite.addEventListener(oleAutomationApplication, "{00024413-0000-0000-C000-000000000046}", 1558, listener);
        }
        if (this.progId.equals("Word.Document")) {
            controlSite.addEventListener(oleAutomationApplication, "{000209FE-0000-0000-C000-000000000046}", 3, listener);
            controlSite.addEventListener(oleAutomationApplication, "{000209FE-0000-0000-C000-000000000046}", 10, listener);
            controlSite.addEventListener(oleAutomationApplication, "{000209FE-0000-0000-C000-000000000046}", 12, listener);
        }
    }

    private void createInfo(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.formToolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Microsoft Office Editor");
        this.createProblemSection(scrolledFormComposite);
        this.createSolutionSection(scrolledFormComposite);
    }

    private void createProblemSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Problem");
        section.setDescription("There has gone something wrong to open the editor.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        if (OperatingSystemUtils.isWindows()) {
            this.createLabel(client, "The editor couldn't be started.", "warn.gif");
            this.createLabel(client, "Is an office version already installed?", "question.gif");
            this.createLabel(client, "Have you installed the latest office version?", "question.gif");
            this.createLabel(client, "Have you tried *.xls and *.doc instead of *.xlsx and *.docx formats?", "question.gif");
            this.createLabel(client, "Are you able to open the office file directly?", "question.gif");
        } else {
            this.createLabel(client, "You're not using Microsoft Windows. Read the solution section.", "warn.gif");
        }
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createSolutionSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Solution");
        section.setDescription("You may chose another office package.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createLabel(client, "There are some free office alternatives available:", "info.gif");
        this.createLink(client, "LibreOffice", "http://www.libreoffice.org");
        this.createLink(client, "OpenOffice", "http://www.openoffice.org");
        this.createLabel(client, "You can use the office package in combination with the NOA4e plug-in:", "info.gif");
        this.createLink(client, "NOA4e plug-in", "http://ubion.ion.ag/loesungen/003officeintegrationeditor");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createLabel(Composite parent, String text, String image) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        CLabel label = new CLabel(parent, 16384);
        label.setText(text);
        if (image != null) {
            label.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        }
        label.setLayoutData((Object)gridData);
    }

    private void createLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(String.valueOf(text) + " (<a>" + url + "</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Program.launch((String)url);
            }
        });
    }

    public void setFocus() {
        if (this.isOleEditorActive()) {
            this.oleControlSite.setFocus();
        }
    }

    private boolean isOleEditorActive() {
        return this.oleControlSite != null;
    }

    public void dispose() {
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
    }
}

