/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMirroredMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LibraryMassSpectrumDifferenceUI
extends Composite {
    private static final Logger logger = Logger.getLogger(LibraryMassSpectrumDifferenceUI.class);
    private Label infoLabelPositive;
    private SimpleMirroredMassSpectrumUI mirroredMassSpectrumUI;
    private Label infoLabelNegative;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;

    public LibraryMassSpectrumDifferenceUI(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.infoLabelPositive = new Label(composite, 0);
        this.infoLabelPositive.setText("");
        this.infoLabelPositive.setLayoutData((Object)new GridData(768));
        this.mirroredMassSpectrumUI = new SimpleMirroredMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mirroredMassSpectrumUI.setLayoutData(gridData);
        this.infoLabelNegative = new Label(composite, 0);
        this.infoLabelNegative.setText("");
        this.infoLabelNegative.setLayoutData((Object)new GridData(768));
    }

    public void update(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum, boolean forceReload) {
        if (unknownMassSpectrum != null && libraryMassSpectrum != null) {
            try {
                IScanMSD differenceMassSpectrumPositive = unknownMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IScanMSD differenceMassSpectrumNegative = libraryMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IExtractedIonSignal extractedIonSignalUnknown = differenceMassSpectrumPositive.getExtractedIonSignal();
                IExtractedIonSignal extractedIonSignalLibrary = differenceMassSpectrumNegative.getExtractedIonSignal();
                int startIon = extractedIonSignalUnknown.getStartIon() < extractedIonSignalLibrary.getStartIon() ? extractedIonSignalUnknown.getStartIon() : extractedIonSignalLibrary.getStartIon();
                int stopIon = extractedIonSignalUnknown.getStopIon() > extractedIonSignalLibrary.getStopIon() ? extractedIonSignalUnknown.getStopIon() : extractedIonSignalLibrary.getStopIon();
                differenceMassSpectrumPositive.getIons().clear();
                differenceMassSpectrumNegative.getIons().clear();
                int ion = startIon;
                while (ion <= stopIon) {
                    float abundance = extractedIonSignalUnknown.getAbundance(ion) - extractedIonSignalLibrary.getAbundance(ion);
                    if (abundance < 0.0f) {
                        differenceMassSpectrumNegative.addIon(this.getIon(ion, abundance *= -1.0f));
                    } else {
                        differenceMassSpectrumPositive.addIon(this.getIon(ion, abundance));
                    }
                    ++ion;
                }
                this.setMassSpectrumLabel(differenceMassSpectrumPositive, differenceMassSpectrumNegative);
                this.mirroredMassSpectrumUI.update(differenceMassSpectrumPositive, differenceMassSpectrumNegative, forceReload);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
            }
        } else {
            this.mirroredMassSpectrumUI.update(null, null, true);
        }
    }

    private IIon getIon(int mz, float abundance) {
        Ion ion = null;
        try {
            ion = new Ion((double)mz, abundance);
        }
        catch (AbundanceLimitExceededException e) {
            logger.warn((Object)e);
        }
        catch (IonLimitExceededException e) {
            logger.warn((Object)e);
        }
        return ion;
    }

    private void setMassSpectrumLabel(IScanMSD differenceMassSpectrumPositive, IScanMSD differenceMassSpectrumNegative) {
        this.setMassSpectrumLabel(differenceMassSpectrumPositive, "(+) [U-L] UNKNOWN MS = ", this.infoLabelPositive);
        this.setMassSpectrumLabel(differenceMassSpectrumNegative, "(-) [U-L] LIBRARY MS = ", this.infoLabelNegative);
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, String title, Label label) {
        StringBuilder builder = new StringBuilder();
        builder.append(title);
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            builder.append("NAME: ");
            builder.append(libraryInformation.getName());
            builder.append(" | ");
            builder.append("CAS: ");
            builder.append(libraryInformation.getCasNumber());
            builder.append(" | ");
        }
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("RI: ");
        if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
            builder.append(Integer.toString((int)massSpectrum.getRetentionIndex()));
        } else {
            builder.append(this.decimalFormat.format(massSpectrum.getRetentionIndex()));
        }
        label.setText(builder.toString());
    }
}

