/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components;

import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.notifier.IPeakMSDSelectionUpdateNotifier;
import org.eclipse.chemclipse.swt.ui.components.AbstractLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.Range;

public abstract class AbstractPeakLineSeriesUI
extends AbstractLineSeriesUI
implements ISeriesSetter,
KeyListener,
MouseListener,
IPeakMSDSelectionUpdateNotifier {
    protected IPeakMSD peak;

    public AbstractPeakLineSeriesUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public void update(IPeakMSD peak, boolean forceReload) {
        this.peak = peak;
        if (!this.isMaster() || this.isMaster() && forceReload) {
            IPeakModelMSD peakModel = this.peak.getPeakModel();
            double maxSignal = peakModel.getPeakAbundance() + peakModel.getBackgroundAbundance();
            this.setMaxSignal(maxSignal);
            this.setSeries(forceReload);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void setSeries(boolean forceReload) {
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        this.getAxisSet().adjustRange();
        this.setSecondaryRanges();
        this.redraw();
    }

    private void setSecondaryRanges() {
        assert (this.getXAxisBottom() != null) : "The minutes instance must be not null.";
        assert (this.getYAxisRight() != null) : "The relativeAbundance instance must be not null.";
        double min = (double)this.peak.getPeakModel().getStartRetentionTime() / 60000.0;
        double max = (double)this.peak.getPeakModel().getStopRetentionTime() / 60000.0;
        Range range = new Range(min, max);
        this.getXAxisBottom().setRange(range);
        IPeakModelMSD peakModel = this.peak.getPeakModel();
        min = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)0.0);
        max = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)(peakModel.getPeakAbundance() + peakModel.getBackgroundAbundance()));
        range = new Range(min, max);
        this.getYAxisRight().setRange(range);
    }

    public void redrawXAxisBottomScale() {
        assert (this.getXAxisTop() != null) : "The xAxisTop instance must be not null.";
        assert (this.getXAxisBottom() != null) : "The xAxisBottom instance must be not null.";
        Range range = this.getXAxisTop().getRange();
        double min = range.lower / 60000.0;
        double max = range.upper / 60000.0;
        ChartUtil.setRange((IAxis)this.getXAxisBottom(), (double)min, (double)max);
    }
}

