/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.ui.wizards.TreeViewerFilesystemSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.MassSpectrumIdentifier;
import org.eclipse.chemclipse.ux.extension.msd.ui.provider.MassSpectrumFileExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.msd.ui.provider.MassSpectrumFileExplorerLabelProvider;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class MassSpectrumFileExplorer {
    private TreeViewer treeViewer;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @Inject
    public MassSpectrumFileExplorer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new MassSpectrumFileExplorerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MassSpectrumFileExplorerLabelProvider());
        TreeViewerFilesystemSupport.retrieveAndSetLocalFileSystem((TreeViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                File file;
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null && (file = (File)firstElement).isDirectory()) {
                    MassSpectrumFileExplorer.this.treeViewer.refresh(firstElement);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
                MassSpectrumFileExplorer.this.openMassSpectrumEditor(file);
            }
        });
    }

    @Focus
    private void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    private void openMassSpectrumEditor(File file) {
        if (MassSpectrumIdentifier.isMassSpectrum(file) || MassSpectrumIdentifier.isMassSpectrumDirectory(file)) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            MInputPart part = MBasicFactory.INSTANCE.createInputPart();
            part.setElementId("org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumEditor");
            part.setContributionURI("bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.MassSpectrumEditor");
            part.setObject((Object)file.getAbsolutePath());
            part.setIconURI("platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/massSpectrum.gif");
            part.setLabel(file.getName());
            part.setTooltip("Mass Spectrum - Detector Type: MSD");
            part.setCloseable(true);
            partStack.getChildren().add(part);
            this.partService.showPart((MPart)part, EPartService.PartState.ACTIVATE);
        }
    }
}

