/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider;

import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIonTransition;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class IonTransitionTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IMarkedIonTransition && e2 instanceof IMarkedIonTransition) {
            IMarkedIonTransition markedIonTransition1 = (IMarkedIonTransition)e1;
            IIonTransition ionTransition1 = markedIonTransition1.getIonTransition();
            IMarkedIonTransition markedIonTransition2 = (IMarkedIonTransition)e2;
            IIonTransition ionTransition2 = markedIonTransition2.getIonTransition();
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = ionTransition2.getCompoundName().compareTo(ionTransition1.getCompoundName());
                    break;
                }
                case 1: {
                    sortOrder = Integer.compare(ionTransition2.getQ1Ion(), ionTransition1.getQ1Ion());
                    break;
                }
                case 2: {
                    sortOrder = Double.compare(ionTransition2.getQ1Resolution(), ionTransition1.getQ1Resolution());
                    break;
                }
                case 3: {
                    sortOrder = Double.compare(ionTransition2.getQ3Ion(), ionTransition1.getQ3Ion());
                    break;
                }
                case 4: {
                    sortOrder = Double.compare(ionTransition2.getQ3Resolution(), ionTransition1.getQ3Resolution());
                    break;
                }
                case 5: {
                    sortOrder = Double.compare(ionTransition2.getCollisionEnergy(), ionTransition1.getCollisionEnergy());
                    break;
                }
                case 6: {
                    sortOrder = Boolean.compare(markedIonTransition2.isSelected(), markedIonTransition1.isSelected());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

