/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.IPeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator.IQuantitationCalculatorMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalsMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IntegrationQuantitationSupport;
import org.eclipse.chemclipse.msd.model.exceptions.EvaluationException;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationEntryMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.equations.QuadraticEquation;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;

public class QuantitationCalculatorMSD
implements IQuantitationCalculatorMSD {
    private static final Logger logger = Logger.getLogger(QuantitationCalculatorMSD.class);

    @Override
    public List<IQuantitationEntryMSD> calculateQuantitationResults(IPeakMSD peak, List<IQuantitationCompoundMSD> quantitationCompounds, IPeakQuantifierProcessingInfo processingInfo) {
        ArrayList<IQuantitationEntryMSD> quantitationEntries = new ArrayList<IQuantitationEntryMSD>();
        for (IQuantitationCompoundMSD quantitationCompound : quantitationCompounds) {
            try {
                List<IQuantitationEntryMSD> quantitationEntriesPeak = this.calculateQuantitationResults(peak, quantitationCompound);
                quantitationEntries.addAll(quantitationEntriesPeak);
            }
            catch (Exception e) {
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.WARN, "ChemClipse Quantitation", "Something has gone wrong to quantify the peak: " + peak + " using the quantitation compound: " + quantitationCompound));
                logger.warn((Object)e);
            }
        }
        return quantitationEntries;
    }

    @Override
    public List<IQuantitationEntryMSD> calculateQuantitationResults(IPeakMSD peak, IQuantitationCompoundMSD quantitationCompound) throws EvaluationException {
        if (peak == null || quantitationCompound == null) {
            throw new EvaluationException("Peak and QuantitationCompound must be not null.");
        }
        if (peak.getIntegratedArea() <= 0.0) {
            logger.warn((Object)("Quantitation - peak area is 0: " + peak));
            throw new EvaluationException("The peak area must be greater than 0.");
        }
        IntegrationQuantitationSupport integrationQuantitationSupport = new IntegrationQuantitationSupport(peak);
        if (quantitationCompound.isUseTIC()) {
            if (integrationQuantitationSupport.validateTIC()) {
                return this.getQuantitationEntriesTIC(quantitationCompound, peak);
            }
            throw new EvaluationException("The peak integration entries (m/z - abundance) do not match with the quantitation TIC ion. See log file.");
        }
        IQuantitationSignalsMSD quantitationSignals = quantitationCompound.getQuantitationSignalsMSD();
        List selectedQuantitationIons = quantitationSignals.getSelectedIons();
        if (integrationQuantitationSupport.validateXIC(selectedQuantitationIons)) {
            return this.getQuantitationEntriesXIC(quantitationCompound, peak, selectedQuantitationIons, integrationQuantitationSupport);
        }
        throw new EvaluationException("The peak integration entries (m/z - abundance) do not match with the quantitation XIC ions. See log file.");
    }

    private List<IQuantitationEntryMSD> getQuantitationEntriesTIC(IQuantitationCompoundMSD quantitationCompound, IPeakMSD peak) {
        ArrayList<IQuantitationEntryMSD> quantitationEntries = new ArrayList<IQuantitationEntryMSD>();
        double integratedArea = peak.getIntegratedArea();
        double ion = 0.0;
        IQuantitationEntryMSD quantitationEntry = this.getQuantitationEntry(ion, quantitationCompound, integratedArea);
        quantitationEntries.add(quantitationEntry);
        return quantitationEntries;
    }

    private List<IQuantitationEntryMSD> getQuantitationEntriesXIC(IQuantitationCompoundMSD quantitationCompound, IPeakMSD peak, List<Double> selectedQuantitationIons, IntegrationQuantitationSupport integrationQuantitationSupport) {
        ArrayList<IQuantitationEntryMSD> quantitationEntries = new ArrayList<IQuantitationEntryMSD>();
        IPeakMassSpectrum massSpectrum = peak.getExtractedMassSpectrum();
        IExtractedIonSignal extractedIonSignal = massSpectrum.getExtractedIonSignal();
        float totalSignalMassSpectrum = extractedIonSignal.getTotalSignal();
        for (double ion : selectedQuantitationIons) {
            IQuantitationEntryMSD quantitationEntry;
            double integratedArea = integrationQuantitationSupport.getIntegrationArea(ion);
            float abundance = extractedIonSignal.getAbundance((int)ion);
            if (integrationQuantitationSupport.isTheTotalSignalIntegrated()) {
                float percentageIonAbundance = (float)(1.0 / (double)totalSignalMassSpectrum * (double)abundance);
                quantitationEntry = this.getQuantitationEntry(ion, quantitationCompound, integratedArea * (double)percentageIonAbundance);
            } else {
                quantitationEntry = this.getQuantitationEntry(ion, quantitationCompound, integratedArea);
            }
            quantitationEntries.add(quantitationEntry);
        }
        return quantitationEntries;
    }

    private IQuantitationEntryMSD getQuantitationEntry(double ion, IQuantitationCompoundMSD quantitationCompound, double integratedArea) {
        String name = quantitationCompound.getName();
        String chemicalClass = quantitationCompound.getChemicalClass();
        String concentrationUnit = quantitationCompound.getConcentrationUnit();
        boolean isCrossZero = quantitationCompound.isCrossZero();
        double concentration = 0.0;
        CalibrationMethod calibrationMethod = quantitationCompound.getCalibrationMethod();
        switch (calibrationMethod) {
            case LINEAR: {
                LinearEquation linearEquation = quantitationCompound.getConcentrationResponseEntriesMSD().getLinearEquation(ion, isCrossZero);
                concentration = linearEquation.calculateX(integratedArea);
                break;
            }
            case QUADRATIC: {
                double factorAverage = quantitationCompound.getConcentrationResponseEntriesMSD().getAverageFactor(ion, isCrossZero);
                double concentrationAverage = factorAverage * integratedArea;
                QuadraticEquation quadraticEquation = quantitationCompound.getConcentrationResponseEntriesMSD().getQuadraticEquation(ion, isCrossZero);
                double concentration1 = quadraticEquation.calculateX(integratedArea, true);
                double concentration2 = quadraticEquation.calculateX(integratedArea, false);
                double delta1 = Math.abs(concentration1 - concentrationAverage);
                double delta2 = Math.abs(concentration2 - concentrationAverage);
                concentration = delta1 < delta2 ? concentration1 : concentration2;
                break;
            }
            case AVERAGE: {
                double factor = quantitationCompound.getConcentrationResponseEntriesMSD().getAverageFactor(ion, isCrossZero);
                concentration = factor * integratedArea;
            }
        }
        QuantitationEntryMSD quantitationEntryMSD = new QuantitationEntryMSD(name, concentration, concentrationUnit, integratedArea, ion);
        quantitationEntryMSD.setCalibrationMethod(calibrationMethod.toString());
        quantitationEntryMSD.setUsedCrossZero(isCrossZero);
        quantitationEntryMSD.setChemicalClass(chemicalClass);
        return quantitationEntryMSD;
    }
}

