/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SessionSubtractMassSpectrumView {
    @Inject
    private Composite parent;
    private SimpleMassSpectrumUI simpleMassSpectrumUI;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.simpleMassSpectrumUI = new SimpleMassSpectrumUI(this.parent, 0, MassValueDisplayPrecision.NOMINAL);
        this.subscribe();
        this.update();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.simpleMassSpectrumUI.setFocus();
    }

    public void update() {
        IScanMSD massSpectrum = PreferenceSupplier.getSessionSubtractMassSpectrum();
        if (massSpectrum == null) {
            this.simpleMassSpectrumUI.clear();
        } else {
            this.simpleMassSpectrumUI.update(massSpectrum, true);
        }
    }

    public boolean doUpdate() {
        return this.isPartVisible();
    }

    public boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    SessionSubtractMassSpectrumView.this.update();
                }
            };
            this.eventBroker.subscribe("filter/supplier/subtract/update/session/subtractmassspectrum", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

