/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISlopes;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Sample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Slopes;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.IChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.ejml.example.PrincipalComponentAnalysis;

public class PrincipleComponentProcessor {
    private static final Logger logger = Logger.getLogger(PrincipleComponentProcessor.class);
    private static final double NORMALIZATION_FACTOR = 1000.0;

    public IPcaResults process(List<IDataInputEntry> dataInputEntries, int retentionTimeWindow, int numberOfPrincipleComponents, IProgressMonitor monitor, int extractionType) {
        SortedSet<Integer> collectedRetentionTimes;
        if (extractionType < 0 || extractionType > 1) {
            extractionType = 0;
        }
        PcaResults pcaResults = new PcaResults(dataInputEntries);
        pcaResults.setRetentionTimeWindow(retentionTimeWindow);
        pcaResults.setNumberOfPrincipleComponents(numberOfPrincipleComponents);
        pcaResults.setExtractionType(extractionType);
        ArrayList<File> inputFiles = new ArrayList<File>();
        for (IDataInputEntry inputEntry : dataInputEntries) {
            inputFiles.add(new File(inputEntry.getInputFile()));
        }
        if (extractionType == 0) {
            monitor.subTask("Extract peak values");
            Map<String, IPeaks> peakMap = this.extractPeaks(inputFiles, monitor);
            monitor.subTask("Prepare peak values");
            this.preparePcaResults(peakMap, pcaResults);
            collectedRetentionTimes = this.collectRetentionTimes(peakMap);
            List<Integer> extractedRetentionTimes = this.calculateCondensedRetentionTimes(collectedRetentionTimes, retentionTimeWindow);
            int sampleSize = extractedRetentionTimes.size();
            pcaResults.setExtractedRetentionTimes(extractedRetentionTimes);
            Map<String, double[]> pcaPeakMap = this.extractPcaPeakMap(peakMap, extractedRetentionTimes, retentionTimeWindow);
            this.normalizeIntensityValues(pcaPeakMap);
            monitor.subTask("Run PCA");
            PrincipalComponentAnalysis principleComponentAnalysis = this.initializePCA(pcaPeakMap, sampleSize, numberOfPrincipleComponents);
            List<double[]> basisVectors = this.getBasisVectors(principleComponentAnalysis, numberOfPrincipleComponents);
            pcaResults.setBasisVectors(basisVectors);
            this.setEigenSpaceAndErrorValues(principleComponentAnalysis, pcaPeakMap, pcaResults);
        } else if (extractionType == 1) {
            monitor.subTask("Extract scan values");
            Map<String, ISlopes> scanMap = this.extractScans(inputFiles, monitor);
            monitor.subTask("Prepare scan values");
            this.prepareScanPcaResults(scanMap, pcaResults);
            collectedRetentionTimes = this.collectScanRetentionTimes(scanMap);
            List<Integer> extractedRetentionTimes = this.calculateCondensedRetentionTimes(collectedRetentionTimes, retentionTimeWindow);
            int sampleSize = extractedRetentionTimes.size();
            pcaResults.setExtractedRetentionTimes(extractedRetentionTimes);
            Map<String, double[]> pcaScanMap = this.extractPcaScanMap(scanMap, extractedRetentionTimes, retentionTimeWindow);
            this.normalizeScanIntensityValues(pcaScanMap);
            monitor.subTask("Run PCA");
            PrincipalComponentAnalysis principleComponentAnalysis = this.initializePCA(pcaScanMap, sampleSize, numberOfPrincipleComponents);
            List<double[]> basisVectors = this.getBasisVectors(principleComponentAnalysis, numberOfPrincipleComponents);
            pcaResults.setBasisVectors(basisVectors);
            this.setEigenSpaceAndErrorValues(principleComponentAnalysis, pcaScanMap, pcaResults);
        }
        return pcaResults;
    }

    public IPcaResults reEvaluate(IPcaResults pcaResults) {
        int numberOfPrincipleComponents = pcaResults.getNumberOfPrincipleComponents();
        int numSamples = 0;
        int sampleSize = 0;
        Map<ISample, IPcaResult> resultMap = pcaResults.getPcaResultMap();
        for (Map.Entry<ISample, IPcaResult> entry : resultMap.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            ++numSamples;
            sampleSize = entry.getValue().getSampleData().length;
        }
        PrincipalComponentAnalysis principleComponentAnalysis = new PrincipalComponentAnalysis();
        principleComponentAnalysis.setup(numSamples, sampleSize);
        for (Map.Entry<ISample, IPcaResult> entry : resultMap.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            double[] sampleData = entry.getValue().getSampleData();
            principleComponentAnalysis.addSample(sampleData);
        }
        principleComponentAnalysis.computeBasis(numberOfPrincipleComponents);
        List<double[]> basisVectors = this.getBasisVectors(principleComponentAnalysis, numberOfPrincipleComponents);
        pcaResults.setBasisVectors(basisVectors);
        for (Map.Entry<ISample, IPcaResult> entry : resultMap.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            IPcaResult pcaResult = entry.getValue();
            double[] sampleData = pcaResult.getSampleData();
            double[] eigenSpace = principleComponentAnalysis.sampleToEigenSpace(sampleData);
            double errorMemberShip = principleComponentAnalysis.errorMembership(sampleData);
            pcaResult.setEigenSpace(eigenSpace);
            pcaResult.setErrorMemberShip(errorMemberShip);
        }
        return pcaResults;
    }

    private Map<String, ISlopes> extractScans(List<File> scanFiles, IProgressMonitor monitor) {
        HashMap<String, ISlopes> scanMap = new HashMap<String, ISlopes>();
        for (File scanFile : scanFiles) {
            IChromatogramMSDImportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convert((File)scanFile, (IProgressMonitor)monitor);
            try {
                IChromatogramMSD chromatogram = processingInfo.getChromatogram();
                String name = this.extractNameFromFile(scanFile, "n.a.");
                Slopes slopes = new Slopes();
                ArrayList<Float> slopeList = new ArrayList<Float>();
                ArrayList<Integer> retentionTimes = new ArrayList<Integer>();
                float previousSignal = 0.0f;
                int previousTime = 0;
                for (IScan scan : chromatogram.getScans()) {
                    float currentSignal = scan.getTotalSignal();
                    int currentTime = scan.getRetentionTime();
                    float slope = (currentSignal - previousSignal) / (float)(currentTime - previousTime);
                    slopeList.add(Float.valueOf(slope));
                    retentionTimes.add(currentTime);
                    previousSignal = currentSignal;
                    previousTime = currentTime;
                }
                slopes.setSlopes(slopeList);
                slopes.setRetentionTimes(retentionTimes);
                scanMap.put(name, slopes);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        return scanMap;
    }

    private void prepareScanPcaResults(Map<String, ISlopes> scanMap, IPcaResults pcaResults) {
        Map<ISample, IPcaResult> pcaResultMap = pcaResults.getPcaResultMap();
        for (Map.Entry<String, ISlopes> entry : scanMap.entrySet()) {
            PcaResult pcaResult = new PcaResult();
            pcaResult.setSlopes(entry.getValue());
            pcaResultMap.put(new Sample(entry.getKey()), pcaResult);
        }
    }

    private SortedSet<Integer> collectScanRetentionTimes(Map<String, ISlopes> scanMap) {
        TreeSet<Integer> collectedRetentionTimes = new TreeSet<Integer>();
        for (Map.Entry<String, ISlopes> scansEntry : scanMap.entrySet()) {
            ISlopes islopes = scansEntry.getValue();
            List<Integer> retentionTimes = islopes.getRetentionTimes();
            for (Integer retentionTime : retentionTimes) {
                collectedRetentionTimes.add(retentionTime);
            }
        }
        return collectedRetentionTimes;
    }

    private Map<String, double[]> extractPcaScanMap(Map<String, ISlopes> scanMap, List<Integer> extractedRetentionTimes, int retentionTimeWindow) {
        HashMap<String, double[]> pcaScanMap = new HashMap<String, double[]>();
        for (Map.Entry<String, ISlopes> ScansEntry : scanMap.entrySet()) {
            String name = ScansEntry.getKey();
            ISlopes scans = ScansEntry.getValue();
            double[] intensityValues = this.extractPcaScanSlopeValues(scans, extractedRetentionTimes, retentionTimeWindow);
            pcaScanMap.put(name, intensityValues);
        }
        return pcaScanMap;
    }

    private double[] extractPcaScanSlopeValues(ISlopes scans, List<Integer> extractedRetentionTimes, int retentionTimeWindow) {
        int retentionTimeDelta = retentionTimeWindow / 2;
        double[] slopeValues = new double[extractedRetentionTimes.size()];
        int index = 0;
        for (int extractedRetentionTime : extractedRetentionTimes) {
            int leftRetentionTimeBound = extractedRetentionTime - retentionTimeDelta;
            int rightRetentionTimeBound = extractedRetentionTime + retentionTimeDelta;
            List<Integer> retentionTimes = scans.getRetentionTimes();
            List<Float> slopes = scans.getSlopes();
            int current = 0;
            for (Float slope : slopes) {
                int retentionTime = retentionTimes.get(current);
                if (retentionTime < leftRetentionTimeBound || retentionTime > rightRetentionTimeBound) continue;
                slopeValues[index++] = slope.floatValue();
            }
        }
        return slopeValues;
    }

    private void preparePcaResults(Map<String, IPeaks> peakMap, IPcaResults pcaResults) {
        Map<ISample, IPcaResult> pcaResultMap = pcaResults.getPcaResultMap();
        for (Map.Entry<String, IPeaks> entry : peakMap.entrySet()) {
            PcaResult pcaResult = new PcaResult();
            pcaResult.setPeaks(entry.getValue());
            pcaResultMap.put(new Sample(entry.getKey()), pcaResult);
        }
    }

    private PrincipalComponentAnalysis initializePCA(Map<String, double[]> pcaPeakMap, int sampleSize, int numberOfPrincipleComponents) {
        int numSamples = pcaPeakMap.size();
        PrincipalComponentAnalysis principleComponentAnalysis = new PrincipalComponentAnalysis();
        principleComponentAnalysis.setup(numSamples, sampleSize);
        for (Map.Entry<String, double[]> entry : pcaPeakMap.entrySet()) {
            double[] sampleData = entry.getValue();
            principleComponentAnalysis.addSample(sampleData);
        }
        principleComponentAnalysis.computeBasis(numberOfPrincipleComponents);
        return principleComponentAnalysis;
    }

    private List<double[]> getBasisVectors(PrincipalComponentAnalysis principleComponentAnalysis, int numberOfPrincipleComponents) {
        ArrayList<double[]> basisVectors = new ArrayList<double[]>();
        int principleComponent = 0;
        while (principleComponent < numberOfPrincipleComponents) {
            double[] basisVector = principleComponentAnalysis.getBasisVector(principleComponent);
            basisVectors.add(basisVector);
            ++principleComponent;
        }
        return basisVectors;
    }

    private void setEigenSpaceAndErrorValues(PrincipalComponentAnalysis principleComponentAnalysis, Map<String, double[]> pcaPeakMap, IPcaResults pcaResults) {
        for (Map.Entry<String, double[]> entry : pcaPeakMap.entrySet()) {
            IPcaResult pcaResult = pcaResults.getPcaResultMap().get(new Sample(entry.getKey()));
            double[] sampleData = entry.getValue();
            double[] eigenSpace = principleComponentAnalysis.sampleToEigenSpace(sampleData);
            double errorMemberShip = principleComponentAnalysis.errorMembership(sampleData);
            pcaResult.setSampleData(sampleData);
            pcaResult.setEigenSpace(eigenSpace);
            pcaResult.setErrorMemberShip(errorMemberShip);
        }
    }

    private void normalizeIntensityValues(Map<String, double[]> pcaPeakMap) {
        double[] sampleData;
        double sampleMax = 0.0;
        for (Map.Entry<String, double[]> entry : pcaPeakMap.entrySet()) {
            sampleData = entry.getValue();
            double sampleDataMax = Calculations.getMax((double[])sampleData);
            double d = sampleMax = sampleDataMax > sampleMax ? sampleDataMax : sampleMax;
        }
        if (sampleMax > 0.0) {
            for (Map.Entry<String, double[]> entry : pcaPeakMap.entrySet()) {
                sampleData = entry.getValue();
                int i = 0;
                while (i < sampleData.length) {
                    double value = sampleData[i];
                    if (value > 0.0) {
                        double normalizedValue;
                        sampleData[i] = normalizedValue = 1000.0 / sampleMax * value;
                    }
                    ++i;
                }
                entry.setValue(sampleData);
            }
        }
    }

    private void normalizeScanIntensityValues(Map<String, double[]> pcaScanMap) {
        double[] sampleData;
        double sampleMax = 0.0;
        for (Map.Entry<String, double[]> entry : pcaScanMap.entrySet()) {
            sampleData = entry.getValue();
            double sampleDataMax = Calculations.getMax((double[])sampleData);
            double d = sampleMax = sampleDataMax > sampleMax ? sampleDataMax : sampleMax;
        }
        if (sampleMax > 0.0) {
            for (Map.Entry<String, double[]> entry : pcaScanMap.entrySet()) {
                sampleData = entry.getValue();
                int i = 0;
                while (i < sampleData.length) {
                    double value = sampleData[i];
                    if (value > 0.0) {
                        double normalizedValue;
                        sampleData[i] = normalizedValue = 1000.0 / sampleMax * value;
                    }
                    ++i;
                }
                entry.setValue(sampleData);
            }
        }
    }

    private Map<String, double[]> extractPcaPeakMap(Map<String, IPeaks> peakMap, List<Integer> extractedRetentionTimes, int retentionTimeWindow) {
        HashMap<String, double[]> pcaPeakMap = new HashMap<String, double[]>();
        for (Map.Entry<String, IPeaks> peaksEntry : peakMap.entrySet()) {
            String name = peaksEntry.getKey();
            IPeaks peaks = peaksEntry.getValue();
            double[] intensityValues = this.extractPcaPeakIntensityValues(peaks, extractedRetentionTimes, retentionTimeWindow);
            pcaPeakMap.put(name, intensityValues);
        }
        return pcaPeakMap;
    }

    private List<Integer> calculateCondensedRetentionTimes(SortedSet<Integer> collectedRetentionTimes, int retentionTimeWindow) {
        int retentionTimeCondensed;
        ArrayList<Integer> extractedRetentionTimes = new ArrayList<Integer>();
        ArrayList<Integer> retentionTimes = null;
        Iterator iterator = collectedRetentionTimes.iterator();
        if (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            int retentionTimeMarker = retentionTime + retentionTimeWindow;
            retentionTimes = new ArrayList<Integer>();
            retentionTimes.add(retentionTime);
            while (iterator.hasNext()) {
                retentionTime = (Integer)iterator.next();
                if (retentionTime > retentionTimeMarker) {
                    retentionTimeCondensed = this.calculateCondensedRetentionTime(retentionTimes);
                    if (retentionTimeCondensed > 0) {
                        extractedRetentionTimes.add(retentionTimeCondensed);
                    }
                    retentionTimeMarker = retentionTime + retentionTimeWindow;
                    retentionTimes = new ArrayList();
                    retentionTimes.add(retentionTime);
                    continue;
                }
                retentionTimes.add(retentionTime);
            }
        }
        if ((retentionTimeCondensed = this.calculateCondensedRetentionTime(retentionTimes)) > 0) {
            extractedRetentionTimes.add(retentionTimeCondensed);
        }
        return extractedRetentionTimes;
    }

    private int calculateCondensedRetentionTime(List<Integer> retentionTimes) {
        int size;
        int retentionTimeCondensed = 0;
        if (retentionTimes != null && (size = retentionTimes.size()) > 0) {
            int retentionTimeSum = 0;
            for (Integer rt : retentionTimes) {
                retentionTimeSum += rt.intValue();
            }
            retentionTimeCondensed = retentionTimeSum / size;
        }
        return retentionTimeCondensed;
    }

    private Map<String, IPeaks> extractPeaks(List<File> peakFiles, IProgressMonitor monitor) {
        HashMap<String, IPeaks> peakMap = new HashMap<String, IPeaks>();
        for (File peakFile : peakFiles) {
            try {
                IPeakImportConverterProcessingInfo processingInfo = PeakConverterMSD.convert((File)peakFile, (IProgressMonitor)monitor);
                IPeaks peaks = processingInfo.getPeaks();
                String name = this.extractNameFromFile(peakFile, "n.a.");
                peakMap.put(name, peaks);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return peakMap;
    }

    private SortedSet<Integer> collectRetentionTimes(Map<String, IPeaks> peakMap) {
        TreeSet<Integer> collectedRetentionTimes = new TreeSet<Integer>();
        for (Map.Entry<String, IPeaks> peaksEntry : peakMap.entrySet()) {
            IPeaks peaks = peaksEntry.getValue();
            for (IPeak peak : peaks.getPeaks()) {
                if (!(peak instanceof IPeakMSD)) continue;
                IPeakMSD peakMSD = (IPeakMSD)peak;
                int retentionTime = peakMSD.getPeakModel().getRetentionTimeAtPeakMaximum();
                collectedRetentionTimes.add(retentionTime);
            }
        }
        return collectedRetentionTimes;
    }

    private double[] extractPcaPeakIntensityValues(IPeaks peaks, List<Integer> extractedRetentionTimes, int retentionTimeWindow) {
        int retentionTimeDelta = retentionTimeWindow / 2;
        double[] intensityValues = new double[extractedRetentionTimes.size()];
        int index = 0;
        for (int extractedRetentionTime : extractedRetentionTimes) {
            double abundance = 0.0;
            int leftRetentionTimeBound = extractedRetentionTime - retentionTimeDelta;
            int rightRetentionTimeBound = extractedRetentionTime + retentionTimeDelta;
            for (IPeak peak : peaks.getPeaks()) {
                IPeakMSD peakMSD;
                int retentionTime;
                if (!(peak instanceof IPeakMSD) || (retentionTime = (peakMSD = (IPeakMSD)peak).getPeakModel().getRetentionTimeAtPeakMaximum()) < leftRetentionTimeBound || retentionTime > rightRetentionTimeBound) continue;
                abundance += peakMSD.getIntegratedArea();
            }
            intensityValues[index++] = abundance;
        }
        return intensityValues;
    }

    private String extractNameFromFile(File file, String nameDefault) {
        String fileName;
        if (file != null && (fileName = file.getName()) != "" && fileName != null) {
            String[] parts = fileName.split("\\.");
            if (parts.length > 2) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < parts.length - 1) {
                    builder.append(parts[i]);
                    builder.append(".");
                    ++i;
                }
                String name = builder.toString();
                nameDefault = name.substring(0, name.length() - 1);
            } else if (parts.length == 2) {
                nameDefault = parts[0];
            }
        }
        return nameDefault;
    }
}

