/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakIntegrationEntriesLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIntegrationEntryMSD) {
            IIntegrationEntryMSD integrationEntryMSD = (IIntegrationEntryMSD)element;
            switch (columnIndex) {
                case 0: {
                    double ion = integrationEntryMSD.getIon();
                    if (ion == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(ion);
                    break;
                }
                case 1: {
                    text = decimalFormat.format(integrationEntryMSD.getIntegratedArea());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("integrationResults.gif", "16x16");
    }
}

