/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.AbstractExtendedMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class SimpleMirroredMassSpectrumUI
extends AbstractExtendedMassSpectrumUI {
    private IScanMSD mirroredMassSpectrum;

    public SimpleMirroredMassSpectrumUI(Composite parent, int style, MassValueDisplayPrecision massSpectrumType) {
        super(parent, style, massSpectrumType);
    }

    @Override
    public void update(IScanMSD massSpectrum, boolean forceReload) {
        this.update(massSpectrum, massSpectrum, forceReload);
    }

    public void update(IScanMSD massSpectrum, IScanMSD mirroredMassSpectrum, boolean forceReload) {
        this.mirroredMassSpectrum = mirroredMassSpectrum;
        super.update(massSpectrum, forceReload);
    }

    public void setViewSeries() {
        if (this.massSpectrum != null) {
            ISeries series = SeriesConverterMSD.convertNominalMassSpectrum(this.massSpectrum, Sign.POSITIVE);
            this.multipleLineSeries.add(series);
            IBarSeries barSeriesPositive = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, String.valueOf(series.getId()) + "+");
            barSeriesPositive.setXSeries(series.getXSeries());
            barSeriesPositive.setYSeries(series.getYSeries());
            barSeriesPositive.setBarWidthStyle(IBarSeries.BarWidthStyle.FIXED);
            barSeriesPositive.setBarWidth(1);
            barSeriesPositive.setBarColor(Colors.RED);
            this.barSeriesPositive = barSeriesPositive;
            if (this.mirroredMassSpectrum != null) {
                ISeries seriesMirrored = SeriesConverterMSD.convertNominalMassSpectrum(this.mirroredMassSpectrum, Sign.NEGATIVE);
                this.multipleLineSeries.add(seriesMirrored);
                IBarSeries barSeriesNegative = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, String.valueOf(seriesMirrored.getId()) + "-");
                barSeriesNegative.setXSeries(seriesMirrored.getXSeries());
                barSeriesNegative.setYSeries(seriesMirrored.getYSeries());
                barSeriesNegative.setBarWidthStyle(IBarSeries.BarWidthStyle.FIXED);
                barSeriesNegative.setBarWidth(1);
                barSeriesNegative.setBarColor(Colors.BLACK);
                this.barSeriesNegative = barSeriesNegative;
            }
        } else {
            this.clear();
        }
    }
}

