/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.ions;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.ions.MarkedIonsChooserContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.ions.MarkedIonsChooserLabelProvider;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MarkedIonsChooser {
    private IMarkedIons markedIons;
    private ExtendedTableViewer tableViewer;
    private Label label;
    private String labelText;
    private Text textIonToAdd;
    private Text textMagnification;
    private NumberFormat numberFormat;
    private String[] titles = new String[]{"m/z", "Magnification"};
    private int[] bounds = new int[]{100, 100};

    public MarkedIonsChooser(Composite parent, int style) {
        this.numberFormat = ValueFormat.getNumberFormatEnglish();
        this.initialize(parent);
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        if (this.label != null) {
            this.labelText = labelText;
            this.label.setText(labelText);
        }
    }

    public IMarkedIons getMarkedIons() {
        return this.markedIons;
    }

    public void setMarkedIons(IMarkedIons markedIons) {
        if (markedIons != null) {
            this.markedIons = markedIons;
            if (this.tableViewer != null) {
                this.tableViewer.setInput((Object)markedIons);
            }
        }
    }

    private void initialize(Composite parent) {
        Composite compositeMarkedIonChooser = new Composite(parent, 0);
        compositeMarkedIonChooser.setLayout((Layout)new GridLayout(3, false));
        GridData gridDataComposite = new GridData(1808);
        gridDataComposite.grabExcessHorizontalSpace = true;
        gridDataComposite.grabExcessVerticalSpace = true;
        compositeMarkedIonChooser.setLayoutData((Object)gridDataComposite);
        this.label = new Label(compositeMarkedIonChooser, 0);
        this.labelText = "Edit marked ions.";
        this.label.setText(this.labelText);
        this.label.setLayoutData((Object)new GridData(768));
        Label label1 = new Label(compositeMarkedIonChooser, 0);
        label1.setText("m/z");
        label1.setLayoutData((Object)new GridData(768));
        Label label2 = new Label(compositeMarkedIonChooser, 0);
        label2.setText("Magnification");
        label2.setLayoutData((Object)new GridData(768));
        Composite compositeEditor = new Composite(compositeMarkedIonChooser, 0);
        compositeEditor.setLayout((Layout)new FillLayout());
        GridData gridDataEditor = new GridData();
        gridDataEditor.horizontalAlignment = 4;
        gridDataEditor.verticalAlignment = 4;
        gridDataEditor.verticalSpan = 2;
        gridDataEditor.grabExcessHorizontalSpace = true;
        gridDataEditor.grabExcessVerticalSpace = true;
        gridDataEditor.heightHint = 230;
        gridDataEditor.widthHint = 150;
        compositeEditor.setLayoutData((Object)gridDataEditor);
        this.tableViewer = new ExtendedTableViewer(compositeEditor, 68354);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new MarkedIonsChooserContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MarkedIonsChooserLabelProvider());
        if (this.markedIons != null) {
            this.tableViewer.setInput((Object)this.markedIons);
        }
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    MarkedIonsChooser.this.tableViewer.copyToClipboard(MarkedIonsChooser.this.titles);
                }
            }
        });
        this.textIonToAdd = new Text(compositeMarkedIonChooser, 2048);
        this.textIonToAdd.setLayoutData((Object)new GridData(768));
        this.textIonToAdd.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    MarkedIonsChooser.this.addIon();
                }
            }
        });
        this.textMagnification = new Text(compositeMarkedIonChooser, 2048);
        this.textMagnification.setText("1");
        this.textMagnification.setLayoutData((Object)new GridData(768));
        GridData gridDataButton = new GridData(768);
        gridDataButton.verticalAlignment = 1;
        Button addIon = new Button(compositeMarkedIonChooser, 0);
        addIon.setText("Add Ion");
        addIon.setLayoutData((Object)gridDataButton);
        addIon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkedIonsChooser.this.addIon();
            }
        });
        Button removeIon = new Button(compositeMarkedIonChooser, 0);
        removeIon.setText("Remove Selected Ion(s)");
        removeIon.setLayoutData((Object)gridDataButton);
        removeIon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MarkedIonsChooser.this.tableViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)MarkedIonsChooser.this.tableViewer.getSelection();
                    List ionList = structuredSelection.toList();
                    for (Object ion : ionList) {
                        MarkedIonsChooser.this.removeMassFragement(ion);
                    }
                }
            }
        });
    }

    private void addIon() {
        block5: {
            String ion = this.textIonToAdd.getText();
            String magnification = this.textMagnification.getText();
            if (ion != null && !ion.equals("") && magnification != null && !magnification.equals("")) {
                try {
                    double parsedIon = this.numberFormat.parse(ion).doubleValue();
                    int parsedMagnification = this.numberFormat.parse(magnification).intValue();
                    if (this.markedIons != null && parsedIon > 0.0 && parsedMagnification >= 0) {
                        this.textIonToAdd.setText("");
                        this.markedIons.add((Object)new MarkedIon(parsedIon, parsedMagnification));
                        this.tableViewer.refresh();
                        break block5;
                    }
                    this.textIonToAdd.setText("TIC (0) can't be added.");
                }
                catch (ParseException parseException) {
                    this.textIonToAdd.setText("Please type in a valid ion.");
                }
            } else {
                this.textIonToAdd.setText("The ion field must be not null.");
            }
        }
    }

    private void removeMassFragement(Object object) {
        if (object instanceof IMarkedIon) {
            IMarkedIon markedIon = (IMarkedIon)object;
            if (this.markedIons != null) {
                this.markedIons.remove((Object)markedIon);
                this.tableViewer.refresh();
            }
        }
    }
}

