/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointSelectionAction;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class RemoveFromWorkingSetAction
extends BreakpointSelectionAction {
    private BreakpointSetElement[] fBreakpoints;

    public RemoveFromWorkingSetAction(BreakpointsView view) {
        super(BreakpointGroupMessages.RemoveFromWorkingSetAction_0, view);
    }

    public void run() {
        if (this.fBreakpoints != null) {
            int i = 0;
            while (i < this.fBreakpoints.length) {
                this.fBreakpoints[i].container.getOrganizer().removeBreakpoint(this.fBreakpoints[i].breakpoint, this.fBreakpoints[i].container.getCategory());
                ++i;
            }
        }
    }

    protected BreakpointSetElement[] getRemovableBreakpoints(IStructuredSelection selection) {
        ArrayList<BreakpointSetElement> res = new ArrayList<BreakpointSetElement>();
        if (selection instanceof ITreeSelection) {
            ITreeSelection tSel = (ITreeSelection)selection;
            TreePath[] paths = tSel.getPaths();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)path.getLastSegment(), IBreakpoint.class);
                if (breakpoint != null) {
                    TreePath parents = path.getParentPath();
                    int j = 0;
                    while (j < parents.getSegmentCount()) {
                        IBreakpointContainer container;
                        Object parent = parents.getSegment(j);
                        if (parent instanceof IBreakpointContainer && (container = (IBreakpointContainer)parent).getCategory() instanceof WorkingSetCategory && container.getOrganizer().canRemove(breakpoint, container.getCategory())) {
                            res.add(new BreakpointSetElement(breakpoint, container));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return res.toArray(new BreakpointSetElement[res.size()]);
    }

    public boolean isEnabled() {
        if (this.fBreakpoints != null) {
            return this.fBreakpoints.length > 0;
        }
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.fBreakpoints = this.getRemovableBreakpoints(selection);
        return this.fBreakpoints.length > 0;
    }

    protected static class BreakpointSetElement {
        IBreakpoint breakpoint;
        IBreakpointContainer container;

        BreakpointSetElement(IBreakpoint b, IBreakpointContainer c) {
            this.breakpoint = b;
            this.container = c;
        }
    }
}

