/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.support;

import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;

public class ConverterTypeSupportWSD {
    private static final Logger logger = Logger.getLogger(ConverterTypeSupportWSD.class);
    public static final String NOT_AVAILABLE = "n.a.";

    public String getConverterName(IChromatogramOutputEntry entry) {
        String converterName = NOT_AVAILABLE;
        try {
            ISupplier converterSupplier = ChromatogramConverterWSD.getChromatogramConverterSupport().getSupplier(entry.getConverterId());
            converterName = converterSupplier.getFilterName();
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
        return converterName;
    }
}

