/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatJarManifestProvider
implements IManifestProvider {
    private static final String SEALED_VALUE = "true";
    private static final String UNSEALED_VALUE = "false";
    private FatJarBuilder fBuilder;

    public FatJarManifestProvider(FatJarBuilder builder) {
        this.fBuilder = builder;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Manifest create(JarPackageData jarPackage) throws CoreException {
        block24: {
            ownManifest = this.createOwn(jarPackage);
            this.setManifestClasspath(ownManifest, this.fBuilder.getManifestClasspath());
            if (this.fBuilder.isMergeManifests()) {
                openZips = new ArrayList<ZipFile>();
                try {
                    otherManifests = new ArrayList<Manifest>();
                    elements = jarPackage.getElements();
                    i = 0;
                    while (i < elements.length) {
                        element = elements[i];
                        if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isArchive()) {
                            zip = JarPackagerUtil.getArchiveFile(((IPackageFragmentRoot)element).getPath());
                            openZips.add(zip);
                            entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                entry = entries.nextElement();
                                if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                                inputStream = null;
                                try {
                                    try {
                                        inputStream = zip.getInputStream(entry);
                                        otherManifest = new Manifest(inputStream);
                                        otherManifests.add(otherManifest);
                                    }
                                    catch (IOException e) {
                                        JavaPlugin.log(e);
                                        if (inputStream == null) continue;
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException v0) {}
                                        continue;
                                    }
                                }
                                catch (Throwable var14_14) {
                                    if (inputStream != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException v1) {}
                                    }
                                    throw var14_14;
                                }
                                if (inputStream == null) continue;
                                try {
                                    inputStream.close();
                                }
                                catch (IOException v2) {}
                            }
                        }
                        ++i;
                    }
                    result = this.merge(ownManifest, otherManifests);
                }
                finally {
                    ** for (file : openZips)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        JavaPlugin.log(e);
                    }
                    continue;
lbl61:
                    // 1 sources

                    break block24;
                }
            }
            result = ownManifest;
        }
        return result;
    }

    private void setManifestClasspath(Manifest ownManifest, String manifestClasspath) {
        if (manifestClasspath != null && !manifestClasspath.trim().equals("")) {
            Attributes mainAttr = ownManifest.getMainAttributes();
            mainAttr.putValue("Class-Path", manifestClasspath);
        }
    }

    private Manifest merge(Manifest ownManifest, List<Manifest> otherManifests) {
        Manifest mergedManifest = new Manifest(ownManifest);
        Map<String, Attributes> mergedEntries = mergedManifest.getEntries();
        for (Manifest otherManifest : otherManifests) {
            Map<String, Attributes> otherEntries = otherManifest.getEntries();
            for (String attributeName : otherEntries.keySet()) {
                if (mergedEntries.containsKey(attributeName)) continue;
                mergedEntries.put(attributeName, otherEntries.get(attributeName));
            }
        }
        return mergedManifest;
    }

    private Manifest createOwn(JarPackageData jarPackage) throws CoreException {
        if (jarPackage.isManifestGenerated()) {
            return this.createGeneratedManifest(jarPackage);
        }
        try {
            return this.createSuppliedManifest(jarPackage);
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public Manifest createDefault(String manifestVersion) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        return manifest;
    }

    protected void putAdditionalEntries(Manifest manifest, JarPackageData jarPackage) {
    }

    private Manifest createGeneratedManifest(JarPackageData jarPackage) {
        Manifest manifest = new Manifest();
        this.putVersion(manifest, jarPackage);
        this.putSealing(manifest, jarPackage);
        this.putMainClass(manifest, jarPackage);
        this.putAdditionalEntries(manifest, jarPackage);
        return manifest;
    }

    private void putVersion(Manifest manifest, JarPackageData jarPackage) {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, jarPackage.getManifestVersion());
    }

    private void putSealing(Manifest manifest, JarPackageData jarPackage) {
        block4: {
            block3: {
                if (!jarPackage.isJarSealed()) break block3;
                manifest.getMainAttributes().put(Attributes.Name.SEALED, SEALED_VALUE);
                IPackageFragment[] packages = jarPackage.getPackagesToUnseal();
                if (packages == null) break block4;
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, UNSEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
                break block4;
            }
            IPackageFragment[] packages = jarPackage.getPackagesToSeal();
            if (packages != null) {
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, SEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
            }
        }
    }

    private void putMainClass(Manifest manifest, JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() != null && jarPackage.getManifestMainClass().getFullyQualifiedName().length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, jarPackage.getManifestMainClass().getFullyQualifiedName());
        }
    }

    private String getInManifestFormat(IPackageFragment packageFragment) {
        String name = packageFragment.getElementName();
        return String.valueOf(name.replace('.', '/')) + '/';
    }

    private Manifest createSuppliedManifest(JarPackageData jarPackage) throws CoreException, IOException {
        Manifest manifest;
        InputStream stream = jarPackage.getManifestFile().getContents(false);
        try {
            manifest = new Manifest(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return manifest;
    }
}

