/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.InitializeAutoResizeColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.InitializeAutoResizeRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.search.command.SearchGridCellsCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.IMarkerSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectCellCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectRowCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectAllCommand;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayer
extends AbstractIndexLayerTransform {
    public static final int MOVE_ALL = -1;
    public static final int NO_SELECTION = -1;
    protected ISelectionModel selectionModel;
    protected IUniqueIndexLayer underlyingLayer;
    protected final PositionCoordinate lastSelectedCell;
    protected final PositionCoordinate selectionAnchor;
    protected Rectangle lastSelectedRegion;
    protected SelectRowCommandHandler selectRowCommandHandler;
    protected SelectCellCommandHandler selectCellCommandHandler;
    protected SelectColumnCommandHandler selectColumnCommandHandler;

    public SelectionLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, null, true);
    }

    public SelectionLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        this(underlyingLayer, null, useDefaultConfiguration);
    }

    public SelectionLayer(IUniqueIndexLayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration) {
        this(underlyingLayer, selectionModel, useDefaultConfiguration, true);
    }

    @Deprecated
    public SelectionLayer(IUniqueIndexLayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration, boolean registerDefaultEventHandler) {
        super(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.setLayerPainter(new SelectionLayerPainter());
        this.setSelectionModel(selectionModel);
        this.lastSelectedCell = new PositionCoordinate(this, -1, -1);
        this.selectionAnchor = new PositionCoordinate(this, -1, -1);
        this.selectRowCommandHandler = new SelectRowCommandHandler(this);
        this.selectCellCommandHandler = new SelectCellCommandHandler(this);
        this.selectColumnCommandHandler = new SelectColumnCommandHandler(this);
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSelectionLayerConfiguration());
        }
    }

    public ISelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ISelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.unregisterEventHandler(this.selectionModel);
        }
        this.selectionModel = selectionModel != null ? selectionModel : new SelectionModel(this);
        this.registerEventHandler(this.selectionModel);
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void addSelection(Rectangle selection) {
        if (!selection.equals((Object)this.getLastSelectedRegion())) {
            this.setSelectionAnchor(this.getLastSelectedCell().columnPosition, this.getLastSelectedCell().rowPosition);
            this.setLastSelectedRegion(selection);
        }
        this.selectionModel.addSelection(selection);
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean fireSelectionEvent) {
        this.selectionModel.clearSelection();
        boolean validLastSelectedCell = SelectionLayer.hasSelection(this.getLastSelectedCell());
        this.setLastSelectedCell(-1, -1);
        this.setLastSelectedRegion(new Rectangle(0, 0, 0, 0));
        this.setSelectionAnchor(-1, -1);
        if (validLastSelectedCell && fireSelectionEvent) {
            this.fireCellSelectionEvent(this.getLastSelectedCell().columnPosition, this.getLastSelectedCell().rowPosition, false, false, false);
        }
    }

    public void clearSelection(int columnPosition, int rowPosition) {
        this.selectionModel.clearSelection(columnPosition, rowPosition);
    }

    public void clearSelection(Rectangle selection) {
        this.selectionModel.clearSelection(selection);
        Point anchorPoint = new Point(this.getSelectionAnchor().columnPosition, this.getSelectionAnchor().rowPosition);
        if (selection.contains(anchorPoint)) {
            this.setSelectionAnchor(-1, -1);
        }
    }

    public void selectAll() {
        Rectangle selection = new Rectangle(0, 0, this.getColumnCount(), this.getRowCount());
        if (this.getLastSelectedCell().columnPosition == -1 || this.getLastSelectedCell().rowPosition == -1) {
            this.setLastSelectedCell(0, 0);
        }
        this.addSelection(selection);
        this.fireCellSelectionEvent(this.getLastSelectedCell().columnPosition, this.getLastSelectedCell().rowPosition, false, false, false);
    }

    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        return this.selectionModel.isCellPositionSelected(columnPosition, rowPosition);
    }

    public void setSelectedCell(int columnPosition, int rowPosition) {
        this.selectCell(columnPosition, rowPosition, false, false);
    }

    protected PositionCoordinate getCellPositionToMoveFrom(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && !withControlMask ? this.getSelectionAnchor() : this.getLastSelectedCellPosition();
    }

    public PositionCoordinate[] getSelectedCellPositions() {
        int[] selectedColumnPositions = this.getSelectedColumnPositions();
        Set<Range> selectedRowPositions = this.getSelectedRowPositions();
        LinkedList<PositionCoordinate> selectedCells = new LinkedList<PositionCoordinate>();
        int columnPositionIndex = 0;
        while (columnPositionIndex < selectedColumnPositions.length) {
            int columnPosition = selectedColumnPositions[columnPositionIndex];
            for (Range rowIndexRange : selectedRowPositions) {
                int rowPositionIndex = rowIndexRange.start;
                while (rowPositionIndex < rowIndexRange.end) {
                    if (this.selectionModel.isCellPositionSelected(columnPosition, rowPositionIndex)) {
                        selectedCells.add(new PositionCoordinate(this, columnPosition, rowPositionIndex));
                    }
                    ++rowPositionIndex;
                }
            }
            ++columnPositionIndex;
        }
        return selectedCells.toArray(new PositionCoordinate[0]);
    }

    public Collection<ILayerCell> getSelectedCells() {
        PositionCoordinate[] selectedCoords;
        HashSet<ILayerCell> selectedCells = new HashSet<ILayerCell>();
        PositionCoordinate[] positionCoordinateArray = selectedCoords = this.getSelectedCellPositions();
        int n = selectedCoords.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate coord = positionCoordinateArray[n2];
            selectedCells.add(this.getCellByPosition(coord.columnPosition, coord.rowPosition));
            ++n2;
        }
        return selectedCells;
    }

    public void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectCellCommandHandler.selectCell(columnPosition, rowPosition, withShiftMask, withControlMask);
    }

    public void selectRegion(int startColumnPosition, int startRowPosition, int regionWidth, int regionHeight) {
        if (this.getLastSelectedRegion() == null) {
            this.setLastSelectedRegion(new Rectangle(startColumnPosition, startRowPosition, regionWidth, regionHeight));
        } else {
            this.setLastSelectedRegion(startColumnPosition, startRowPosition, regionWidth, regionHeight);
        }
        this.selectionModel.addSelection(new Rectangle(this.getLastSelectedRegion().x, this.getLastSelectedRegion().y, this.getLastSelectedRegion().width, this.getLastSelectedRegion().height));
    }

    protected void setLastSelectedRegion(Rectangle region) {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            ((IMarkerSelectionModel)this.selectionModel).setLastSelectedRegion(region);
        } else if (region == null || this.lastSelectedRegion == null) {
            this.lastSelectedRegion = region;
        } else {
            this.lastSelectedRegion.x = region.x;
            this.lastSelectedRegion.y = region.y;
            this.lastSelectedRegion.width = region.width;
            this.lastSelectedRegion.height = region.height;
        }
    }

    protected void setLastSelectedRegion(int startColumnPosition, int startRowPosition, int regionWidth, int regionHeight) {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            ((IMarkerSelectionModel)this.selectionModel).setLastSelectedRegion(startColumnPosition, startRowPosition, regionWidth, regionHeight);
        } else {
            this.lastSelectedRegion.x = startColumnPosition;
            this.lastSelectedRegion.y = startRowPosition;
            this.lastSelectedRegion.width = regionWidth;
            this.lastSelectedRegion.height = regionHeight;
        }
    }

    public PositionCoordinate getSelectionAnchor() {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            Point coordinate = ((IMarkerSelectionModel)this.selectionModel).getSelectionAnchor();
            return new PositionCoordinate(this, coordinate.x, coordinate.y);
        }
        return this.selectionAnchor;
    }

    public void moveSelectionAnchor(int startColumnPositionInRegion, int startRowPosition) {
        this.setSelectionAnchor(startColumnPositionInRegion, startRowPosition);
    }

    void setSelectionAnchor(int columnPosition, int rowPosition) {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            ((IMarkerSelectionModel)this.selectionModel).setSelectionAnchor(new Point(columnPosition, rowPosition));
        } else {
            this.selectionAnchor.columnPosition = columnPosition;
            this.selectionAnchor.rowPosition = rowPosition;
        }
    }

    public PositionCoordinate getLastSelectedCellPosition() {
        PositionCoordinate coordinate = this.getLastSelectedCell();
        if (SelectionLayer.hasSelection(coordinate)) {
            return coordinate;
        }
        return null;
    }

    PositionCoordinate getLastSelectedCell() {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            Point coordinate = ((IMarkerSelectionModel)this.selectionModel).getLastSelectedCell();
            return new PositionCoordinate(this, coordinate.x, coordinate.y);
        }
        return this.lastSelectedCell;
    }

    static boolean hasSelection(PositionCoordinate coordinate) {
        return coordinate.columnPosition != -1 && coordinate.rowPosition != -1;
    }

    public void setLastSelectedCell(int columnPosition, int rowPosition) {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            ((IMarkerSelectionModel)this.selectionModel).setLastSelectedCell(new Point(columnPosition, rowPosition));
        } else {
            this.lastSelectedCell.columnPosition = columnPosition;
            this.lastSelectedCell.rowPosition = rowPosition;
        }
    }

    public Rectangle getLastSelectedRegion() {
        if (this.selectionModel instanceof IMarkerSelectionModel) {
            return ((IMarkerSelectionModel)this.selectionModel).getLastSelectedRegion();
        }
        return this.lastSelectedRegion;
    }

    public boolean hasColumnSelection() {
        return this.getLastSelectedCell().columnPosition != -1;
    }

    public int[] getSelectedColumnPositions() {
        return this.selectionModel.getSelectedColumnPositions();
    }

    public boolean isColumnPositionSelected(int columnPosition) {
        return this.selectionModel.isColumnPositionSelected(columnPosition);
    }

    public int[] getFullySelectedColumnPositions() {
        return this.selectionModel.getFullySelectedColumnPositions(this.getRowCount());
    }

    public boolean isColumnPositionFullySelected(int columnPosition) {
        return this.selectionModel.isColumnPositionFullySelected(columnPosition, this.getRowCount());
    }

    public void selectColumn(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectColumnCommandHandler.selectColumn(columnPosition, rowPosition, withShiftMask, withControlMask);
    }

    public boolean hasRowSelection() {
        return this.getLastSelectedCell().rowPosition != -1;
    }

    public int getSelectedRowCount() {
        return this.selectionModel.getSelectedRowCount();
    }

    public Set<Range> getSelectedRowPositions() {
        return this.selectionModel.getSelectedRowPositions();
    }

    public boolean isRowPositionSelected(int rowPosition) {
        return this.selectionModel.isRowPositionSelected(rowPosition);
    }

    public int[] getFullySelectedRowPositions() {
        return this.selectionModel.getFullySelectedRowPositions(this.getColumnCount());
    }

    public boolean isRowPositionFullySelected(int rowPosition) {
        return this.selectionModel.isRowPositionFullySelected(rowPosition, this.getColumnCount());
    }

    public void selectRow(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        this.selectRowCommandHandler.selectRows(columnPosition, Arrays.asList(rowPosition), withShiftMask, withControlMask, rowPosition);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        String displayMode = super.getDisplayModeByPosition(columnPosition, rowPosition);
        if (this.isCellPositionSelected(columnPosition, rowPosition)) {
            if ("HOVER".equals(displayMode)) {
                return "SELECT_HOVER";
            }
            return "SELECT";
        }
        return displayMode;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        Rectangle cellRectangle;
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        if (cell != null && (cellRectangle = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan())).contains(this.getSelectionAnchor().columnPosition, this.getSelectionAnchor().rowPosition)) {
            labelStack.addLabel("selectionAnchor");
        }
        return labelStack;
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(this.selectCellCommandHandler);
        this.registerCommandHandler(this.selectRowCommandHandler);
        this.registerCommandHandler(this.selectColumnCommandHandler);
        this.registerCommandHandler(new EditSelectionCommandHandler(this));
        this.registerCommandHandler(new InitializeAutoResizeColumnsCommandHandler(this));
        this.registerCommandHandler(new InitializeAutoResizeRowsCommandHandler(this));
        this.registerCommandHandler(new CopyDataCommandHandler(this));
        this.registerCommandHandler(new SearchGridCellsCommandHandler(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof SelectAllCommand && command.convertToTargetLayer(this)) {
            this.selectAll();
            return true;
        }
        if (command instanceof ClearAllSelectionsCommand && command.convertToTargetLayer(this)) {
            this.clear();
            return true;
        }
        if (command instanceof ColumnHideCommand && command.convertToTargetLayer(this)) {
            return this.handleColumnHideCommand((ColumnHideCommand)command);
        }
        if (command instanceof MultiColumnHideCommand && command.convertToTargetLayer(this)) {
            return this.handleMultiColumnHideCommand((MultiColumnHideCommand)command);
        }
        if (command instanceof RowHideCommand && command.convertToTargetLayer(this)) {
            return this.handleRowHideCommand((RowHideCommand)command);
        }
        if (command instanceof MultiRowHideCommand && command.convertToTargetLayer(this)) {
            return this.handleMultiRowHideCommand((MultiRowHideCommand)command);
        }
        if (command instanceof ColumnResizeCommand && command.convertToTargetLayer(this)) {
            return this.handleColumnResizeCommand((ColumnResizeCommand)command);
        }
        if (command instanceof RowResizeCommand && command.convertToTargetLayer(this)) {
            return this.handleRowResizeCommand((RowResizeCommand)command);
        }
        return super.doCommand(command);
    }

    public void fireCellSelectionEvent(int columnPosition, int rowPosition, boolean forcingEntireCellIntoViewport, boolean withShiftMask, boolean withControlMask) {
        CellSelectionEvent selectionEvent = new CellSelectionEvent(this, columnPosition, rowPosition, withShiftMask, withControlMask);
        this.fireLayerEvent(selectionEvent);
    }

    protected boolean handleColumnHideCommand(ColumnHideCommand command) {
        if (this.isColumnPositionFullySelected(command.getColumnPosition())) {
            return this.handleMultiColumnHideCommand(new MultiColumnHideCommand((ILayer)this, this.getFullySelectedColumnPositions()));
        }
        return super.doCommand(command);
    }

    protected boolean handleMultiColumnHideCommand(MultiColumnHideCommand command) {
        for (int columnPosition : command.getColumnPositions()) {
            if (!this.isColumnPositionFullySelected(columnPosition)) continue;
            Rectangle selection = new Rectangle(columnPosition, 0, 1, Integer.MAX_VALUE);
            this.clearSelection(selection);
        }
        return super.doCommand(command);
    }

    protected boolean handleRowHideCommand(RowHideCommand command) {
        if (this.isRowPositionFullySelected(command.getRowPosition())) {
            return this.handleMultiRowHideCommand(new MultiRowHideCommand((ILayer)this, this.getFullySelectedRowPositions()));
        }
        return super.doCommand(command);
    }

    protected boolean handleMultiRowHideCommand(MultiRowHideCommand command) {
        for (int rowPosition : command.getRowPositions()) {
            if (!this.isRowPositionFullySelected(rowPosition)) continue;
            Rectangle selection = new Rectangle(0, rowPosition, Integer.MAX_VALUE, 1);
            this.clearSelection(selection);
        }
        return super.doCommand(command);
    }

    protected boolean handleColumnResizeCommand(ColumnResizeCommand command) {
        if (this.isColumnPositionFullySelected(command.getColumnPosition())) {
            return super.doCommand(new MultiColumnResizeCommand((ILayer)this, this.selectionModel.getFullySelectedColumnPositions(this.getRowCount()), command.getNewColumnWidth()));
        }
        return super.doCommand(command);
    }

    protected boolean handleRowResizeCommand(RowResizeCommand command) {
        if (this.isRowPositionFullySelected(command.getRowPosition())) {
            return super.doCommand(new MultiRowResizeCommand((ILayer)this, this.selectionModel.getFullySelectedRowPositions(this.getColumnCount()), command.getNewHeight()));
        }
        return super.doCommand(command);
    }

    public static enum MoveDirectionEnum {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

