/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.core;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.PeakQuantifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.PeakQuantifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.IPeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.PeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakQuantifier {
    private static final Logger logger = Logger.getLogger(PeakQuantifier.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.quantifier.peakQuantifierSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String PEAK_QUANTIFIER_NAME = "peakQuantifierName";
    private static final String PEAK_QUANTIFIER = "peakQuantifier";
    private static final String NO_PEAK_QUANTIFIER_AVAILABLE = "There is no peak quantifier available.";

    private PeakQuantifier() {
    }

    public static IPeakQuantifierProcessingInfo quantify(IPeakMSD peak, IPeakQuantifierSettings peakQuantifierSettings, String peakQuantifierId, IProgressMonitor monitor) {
        IPeakQuantifier peakQuantifier = PeakQuantifier.getPeakQuantifier(peakQuantifierId);
        IPeakQuantifierProcessingInfo processingInfo = peakQuantifier != null ? peakQuantifier.quantify(peak, peakQuantifierSettings, monitor) : PeakQuantifier.getNoPeakQuantifierProcessingInfo();
        return processingInfo;
    }

    public static IPeakQuantifierProcessingInfo quantify(IPeakMSD peak, String peakQuantifierId, IProgressMonitor monitor) {
        IPeakQuantifier peakQuantifier = PeakQuantifier.getPeakQuantifier(peakQuantifierId);
        IPeakQuantifierProcessingInfo processingInfo = peakQuantifier != null ? peakQuantifier.quantify(peak, monitor) : PeakQuantifier.getNoPeakQuantifierProcessingInfo();
        return processingInfo;
    }

    public static IPeakQuantifierProcessingInfo quantify(List<IPeakMSD> peaks, IPeakQuantifierSettings peakQuantifierSettings, String peakQuantifierId, IProgressMonitor monitor) {
        IPeakQuantifier peakQuantifier = PeakQuantifier.getPeakQuantifier(peakQuantifierId);
        IPeakQuantifierProcessingInfo processingInfo = peakQuantifier != null ? peakQuantifier.quantify(peaks, peakQuantifierSettings, monitor) : PeakQuantifier.getNoPeakQuantifierProcessingInfo();
        return processingInfo;
    }

    public static IPeakQuantifierProcessingInfo quantify(List<IPeakMSD> peaks, String peakQuantifierId, IProgressMonitor monitor) {
        IPeakQuantifier peakQuantifier = PeakQuantifier.getPeakQuantifier(peakQuantifierId);
        IPeakQuantifierProcessingInfo processingInfo = peakQuantifier != null ? peakQuantifier.quantify(peaks, monitor) : PeakQuantifier.getNoPeakQuantifierProcessingInfo();
        return processingInfo;
    }

    public static IPeakQuantifierSupport getPeakQuantifierSupport() {
        IConfigurationElement[] extensions;
        PeakQuantifierSupport baselineDetectorSupport = new PeakQuantifierSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakQuantifierSupplier supplier = new PeakQuantifierSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setPeakQuantifierName(element.getAttribute(PEAK_QUANTIFIER_NAME));
            baselineDetectorSupport.add(supplier);
            ++n2;
        }
        return baselineDetectorSupport;
    }

    private static IPeakQuantifier getPeakQuantifier(String peakQuantifierId) {
        IConfigurationElement element = PeakQuantifier.getConfigurationElement(peakQuantifierId);
        IPeakQuantifier instance = null;
        if (element != null) {
            try {
                instance = (IPeakQuantifier)element.createExecutableExtension(PEAK_QUANTIFIER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String peakQuantifierId) {
        IConfigurationElement[] elements;
        if ("".equals(peakQuantifierId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(peakQuantifierId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IPeakQuantifierProcessingInfo getNoPeakQuantifierProcessingInfo() {
        PeakQuantifierProcessingInfo processingInfo = new PeakQuantifierProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Quantifier", NO_PEAK_QUANTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

