/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core.BatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.BatchProcessJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BatchProcessRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(BatchProcessRunnable.class);
    private IBatchProcessJob batchProcessJob;
    private File file;
    private String filePath;
    private BatchProcessJobReader reader;

    public BatchProcessRunnable(String filePath) {
        this.filePath = filePath;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.reader = new BatchProcessJobReader();
        this.file = new File(this.filePath);
        try {
            monitor.beginTask("Batch Process", -1);
            this.batchProcessJob = this.reader.read(this.file, monitor);
            BatchProcess bp = new BatchProcess();
            IProcessingInfo processingInfo = bp.execute(this.batchProcessJob, monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (FileIsNotReadableException e) {
            logger.warn((Object)e);
        }
        catch (FileIsEmptyException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }
}

