/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class CovarianceRandomDraw {
    private DenseMatrix64F A;
    private Random rand;
    private DenseMatrix64F r;

    public CovarianceRandomDraw(Random rand, DenseMatrix64F cov) {
        this.r = new DenseMatrix64F(cov.numRows, 1);
        CholeskyDecompositionInner_D64 cholesky = new CholeskyDecompositionInner_D64(true);
        if (cholesky.inputModified()) {
            cov = cov.copy();
        }
        if (!cholesky.decompose(cov)) {
            throw new RuntimeException("Decomposition failed!");
        }
        this.A = cholesky.getT();
        this.rand = rand;
    }

    public void next(DenseMatrix64F x) {
        int i = 0;
        while (i < this.r.numRows) {
            this.r.set(i, 0, this.rand.nextGaussian());
            ++i;
        }
        CommonOps.multAdd(this.A, this.r, x);
    }

    public double computeLikelihoodP() {
        double ret = 1.0;
        int i = 0;
        while (i < this.r.numRows) {
            double a = this.r.get(i, 0);
            ret *= Math.exp(-a * a / 2.0);
            ++i;
        }
        return ret;
    }
}

