/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.chol;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CCommonOps;

public abstract class CholeskyDecompositionCommon_CD64
implements CholeskyDecomposition<CDenseMatrix64F> {
    protected int n;
    protected CDenseMatrix64F T;
    protected double[] t;
    protected boolean lower;
    protected Complex64F det = new Complex64F();

    public CholeskyDecompositionCommon_CD64(boolean lower) {
        this.lower = lower;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public boolean decompose(CDenseMatrix64F mat) {
        if (mat.numRows != mat.numCols) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.n = mat.numRows;
        this.T = mat;
        this.t = this.T.data;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    protected abstract boolean decomposeLower();

    protected abstract boolean decomposeUpper();

    @Override
    public CDenseMatrix64F getT(CDenseMatrix64F T) {
        if (T == null) {
            T = new CDenseMatrix64F(this.n, this.n);
        } else {
            if (T.numRows != this.n || T.numCols != this.n) {
                throw new IllegalArgumentException("Unexpected matrix dimension for T.");
            }
            CCommonOps.fill(T, 0.0, 0.0);
        }
        if (this.lower) {
            int i = 0;
            while (i < this.n) {
                int index = i * this.n * 2;
                int j = 0;
                while (j <= i) {
                    T.data[index] = this.T.data[index];
                    T.data[++index] = this.T.data[index];
                    ++index;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.n) {
                int index = (i * this.n + i) * 2;
                int j = i;
                while (j < this.n) {
                    T.data[index] = this.T.data[index];
                    T.data[++index] = this.T.data[index];
                    ++index;
                    ++j;
                }
                ++i;
            }
        }
        return T;
    }

    public CDenseMatrix64F _getT() {
        return this.T;
    }

    @Override
    public Complex64F computeDeterminant() {
        double prod = 1.0;
        int total = this.n * this.n * 2;
        int i = 0;
        while (i < total) {
            prod *= this.t[i];
            i += 2 * (this.n + 1);
        }
        this.det.real = prod * prod;
        this.det.imaginary = 0.0;
        return this.det;
    }
}

