/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.core.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.ITrapezoidPeakIntegratorSupport;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class TrapezoidPeakIntegratorSupport
implements ITrapezoidPeakIntegratorSupport {
    @Override
    public IPeakIntegrationResults calculatePeakIntegrationResults(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        PeakIntegrationResults peakIntegrationResults;
        monitor.subTask("Integrate the peaks");
        if (peaks != null) {
            PeakIntegrator peakIntegrator = new PeakIntegrator();
            peakIntegrationResults = peakIntegrator.integrate(peaks, peakIntegrationSettings, monitor);
        } else {
            peakIntegrationResults = new PeakIntegrationResults();
        }
        return peakIntegrationResults;
    }

    @Override
    public IPeakIntegrationResults calculatePeakIntegrationResults(IChromatogramSelection chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        List peaks = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
            IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
            peaks = chromatogramMSD.getPeaks(chromatogramSelectionMSD);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            IChromatogramSelectionCSD chromatogramSelectionFID = (IChromatogramSelectionCSD)chromatogramSelection;
            IChromatogramCSD chromatogramFID = chromatogramSelectionFID.getChromatogramCSD();
            peaks = chromatogramFID.getPeaks(chromatogramSelectionFID);
        }
        return this.calculatePeakIntegrationResults(peaks, peakIntegrationSettings, monitor);
    }

    @Override
    public IPeakIntegrationResult calculatePeakIntegrationResult(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        monitor.subTask("Integrate the peak");
        PeakIntegrator peakIntegrator = new PeakIntegrator();
        IPeakIntegrationResult peakIntegrationResult = peakIntegrator.integrate(peak, peakIntegrationSettings, monitor);
        return peakIntegrationResult;
    }
}

